\name{netplot}
\alias{netplot}
\title{Plot a Neural Network}
\usage{
netplot (nn, maxcolors=256, colors="size")
}
\arguments{
  \item{nn}{Object returned by \code{\link{ffnet}} or \code{\link{nnet}}.}
  \item{maxcolors}{Maximum number of colors to use.}
  \item{colors}{How to choose colors of links and biases.}
}
\description{
  The architecture of a neural network trained by \code{\link{ffnet}} or
  \code{\link{nnet}} is plotted.
}
\details{
  If \code{colors="none"}, only the structure of the network is
  plotted. If \code{colors="size"}, then links and biases use colors
  proportional to their size, dark blue meaning large negative, dark
  red large positive and white around zero. Links and biases use
  different palettes, i.e., the red's and blue's of links and
  biases need not correspond to the same absolute values.
  
  If \code{colors="pval"}, then only one color (red) is used, with
  intensities proportional to significance (as shown in
  \code{\link{summary.ffnet}}). This works only for
  objects of class \code{\link{ffnet}} with non-singular Hessian.
}
\author{F. Leisch; modifications by A. Trapletti}
\seealso{
  \code{\link{ffnet}}, \code{\link{nnet}}
}
\examples{
  x <- runif (1000, -1, 1)  # Non-linear Regression 
  y <- x^2 - x^3 +0.1*rnorm(x)
  nn <- ffnet (y~x, nhid=5, itmax=100, optim="DFPMIN", shortcut=T)
  netplot (nn)
}
\keyword{hplot, neural}
