#ifndef _OSINFO_H_
#define _OSINFO_H_

/*
 *
 * Thread information and UNIX-like security interfaces
 *
 * $Id: osinfo.h 1.1 2000/10/30 22:51:30 federico Exp $
 *
 * $Log: osinfo.h $
 * Revision 1.1  2000/10/30 22:51:30  federico
 * Initial revision
 *
 */

typedef void idbug_mutex_t;
typedef int (*idbug_mutex_locker_t) (idbug_mutex_t *);
typedef int (*idbug_mutex_unlocker_t) (idbug_mutex_t *);
typedef long unsigned int (*idbug_get_process_id_t) (void * /* key */);
typedef long unsigned int (*idbug_get_thread_id_t) (void *);

struct _db_thread_params_s
  {
    idbug_mutex_t *mutex;
    idbug_mutex_locker_t lock_mutex;
    idbug_mutex_unlocker_t unlock_mutex;

    idbug_get_thread_id_t id;
  };

struct _db_process_params_s
  {
    char *name;
    idbug_get_process_id_t id;
    const struct _db_thread_params_s * thread_params;
  };


struct _db_dbug_security_s
  {
    int (*pchown) (const char *file, int owner, int group);
    int (*pgetuid) (void);
    int (*pgetgid) (void);
  };

typedef struct _db_thread_params_s idbug_thread_params_t;
typedef struct _db_process_params_s idbug_process_params_t;
typedef struct _db_dbug_security_s idbug_security_t;

#endif /* ! _OSINFO_H_ */
