#ifdef IDBUG_OS_W32

#include <windows.h>

/*
 * $Id: w32.c 1.1 2000/10/24 22:31:39 federico Exp $
 * $Log: w32.c $
 * Revision 1.1  2000/10/24 22:31:39  federico
 * Initial revision
 *
 *
 * TODO:
 * - document that _db_init_w32_ initializes for a threaded
 *   interface as default
 * - compile as a dll
 *
 */

void
idbug_init_security (idbug_t * idbug)
{
	idbug->security.pchown = NULL;
	idbug->security.pgetuid = NULL;
	idbug->security.pgetgid = NULL;
}
/*
 * For win32 systems checks that the directory is writable
 */
int
idbug_writable (idbug_t * idbug, const char *pathname)
{
 /* TODO:
  * Look at the cygwin sources ???
  */
  return 1;
}

static int
_db_w32_EnterCriticalSection (void *cs)
{
  return EnterCriticalSection ((CRITICAL_SECTION *) cs), 1;
}

static int
_db_w32_LeaveCriticalSection (void *cs)
{
  return LeaveCriticalSection ((CRITICAL_SECTION *) cs), 1;
}

static long unsigned int
_db_w32_GetCurrentThreadId (void *ctx)
{
	return (long unsigned int) GetCurrentThreadId ();
}

static long unsigned int
_db_w32_GetCurrentProcessId (void *ctx)
{
  return (long unsigned int) GetCurrentProcessId ();
}

/*
 *  FUNCTION
 *
 * _db_init_w32	initialize the interface for win32-like systems
 *
 *  SYNOPSIS
 *
 * int _db_init_w32	(idbug)
 * idbug_t * idbug  pointer to the interface to be initialized
 *
 *  DESCRIPTION
 * Initialize the interface to the dbug library services to be used
 * with a win32-like operating system:
 * - the thread parameters are initialized by _db_init_w32_threads_
 * - the process parameters are initialized by _db_init_w32_process_
 * - the idbug flags are set to: IDBUG_THREADED
 * - the mutex is implemented using a critical section
 * Shoud be called before any multithreading activity starts
 */
static CRITICAL_SECTION Cs;
static const idbug_thread_params_t _db_w32_thread_params =
 {&Cs,
 _db_w32_EnterCriticalSection,
 _db_w32_LeaveCriticalSection,
 _db_w32_GetCurrentThreadId};
static const idbug_process_params_t _db_w32_process_params =
	{"",
	_db_w32_GetCurrentProcessId,
	&_db_w32_thread_params};

EXPORT int
_db_init_w32_ (idbug_t * idbug)
{
	// Init critical section
	InitializeCriticalSection (&Cs);
	return _db_init_ (idbug, IDBUG_THREADED, &_db_w32_process_params,
		NULL, NULL);
}


EXPORT void
_db_deinit_w32_ (idbug_t * idbug)
{
	// Init critical section
	DeleteCriticalSection (&Cs);
}

/*------------------------------------------------------------------------
 Procedure:     LibMain ID:1
 Purpose:       Dll entry point. Called when a dll is loaded or
                unloaded by a process, and when new threads are
                created or destroyed.
 Input:         hDllInst: Instance handle of the dll
                fdwReason: event: attach/detach
                lpvReserved: not used
 Output:        The return value is used only when the fdwReason is
                DLL_PROCESS_ATTACH. True means that the dll has
                sucesfully loaded, False means that the dll is unable
                to initialize and should be unloaded immediately.
 Errors:
------------------------------------------------------------------------*/
BOOL WINAPI
LibMain (HINSTANCE hDLLInst, DWORD fdwReason, LPVOID lpvReserved)
{
  switch (fdwReason)
    {
    case DLL_PROCESS_ATTACH:
      // The DLL is being loaded for the first time by a given process.
      // Perform per-process initialization here.  If the initialization
      // is successful, return TRUE; if unsuccessful, return FALSE.


      break;
    case DLL_PROCESS_DETACH:
      // The DLL is being unloaded by a given process.  Do any
      // per-process clean up here, such as undoing what was done in
      // DLL_PROCESS_ATTACH.  The return value is ignored.


      break;
    case DLL_THREAD_ATTACH:
      // A thread is being created in a process that has already loaded
      // this DLL.  Perform any per-thread initialization here.  The
      // return value is ignored.

      break;
    case DLL_THREAD_DETACH:
      // A thread is exiting cleanly in a process that has already
      // loaded this DLL.  Perform any per-thread clean up here.  The
      // return value is ignored.

      break;
    }
  return TRUE;
}

#endif /* DBUG_OS_W32 */

