#ifndef _AMB_H_
#define _AMB_H_

#include <stddef.h>

#define HASH_IMPLEMENTATION
#include "hash.h"
#include "nodepool.h"

/*
 * typedef void node_pool_t;
 */
typedef hash_t node_table_t;

struct private_amb { /* allocated memory block */
       void * ptr; /* amb doesn't own ptr ... */
       size_t size;
       int how;
       size_t mem_space;
       const char * file;
       int line;
       const char * function;
};


struct private_amb_list { /* list of allocated memory blocks */
       node_table_t * table;
       node_pool_t _table_node_pool;  /* node pool for the hash table */
       node_pool_t * table_node_pool; /* its pointer */
       node_pool_t _node_pool;    /* node pool for mem blocks: may be NULL */
       node_pool_t * node_pool;   /* its pointer */
};

#ifdef IMEM_IMPLEMENTATION
typedef struct private_amb amb_t;
typedef struct private_amb_list amb_list_t;
#else
typedef struct {
	char foo[sizeof (struct private_amb) / sizeof (char)];
} amb_t;

typedef struct {
	char foo[sizeof (struct private_amb_list) / sizeof (char)];
} amb_list_t;
#endif /* IMEM_IMPLEMENTATION */

#endif /* _AMB_H_ */


