#ifndef _IMEMDEFS_H_
#define _IMEMDEFS_H_

#define IMEM_PREFIX(a) 	imem ## _ ## a
#define IMEM_UPREFIX(a) IMEM ## _ ## a

#define a_malloc        IMEM_PREFIX(malloc)
#define a_calloc 				IMEM_PREFIX(calloc)
#define a_realloc       IMEM_PREFIX(realloc)
#define a_free 	        IMEM_PREFIX(free)

#define a_init 					IMEM_PREFIX(init)
#define a_deinit 				IMEM_PREFIX(deinit)

#define a_init_ansi     IMEM_PREFIX(init_ansi)
#define a_init_w32      IMEM_PREFIX(init_w32)
#define a_deinit_w32    IMEM_PREFIX(deinit_w32)

#define a_ansi_calloc		IMEM_PREFIX(ansi_calloc)
#define a_ansi_malloc		IMEM_PREFIX(ansi_malloc)
#define a_ansi_realloc	IMEM_PREFIX(ansi_realloc)
#define a_ansi_free			IMEM_PREFIX(ansi_free)

#define a_w32_calloc		IMEM_PREFIX(w32_calloc)
#define a_w32_malloc		IMEM_PREFIX(w32_malloc)
#define a_w32_realloc		IMEM_PREFIX(w32_realloc)
#define a_w32_free			IMEM_PREFIX(w32_free)

#define a_free_mem_space IMEM_PREFIX(free_mem_space)
#define a_set_mem_space  IMEM_PREFIX(set_mem_space)
#define a_get_mem_space  IMEM_PREFIX(get_mem_space)
#define a_nbytes	 			 IMEM_PREFIX(nbytes)
#define a_mem_space_nblocks IMEM_PREFIX(mem_space_nblocks)
#define a_mem_space_nbytes  IMEM_PREFIX(mem_space_nbytes)
#define a_get_opaque 		IMEM_PREFIX(get_opaque)
#define a_global_s      IMEM_PREFIX(global_s)
#define a_global        IMEM_PREFIX(global)
#define a_set_random_fail IMEM_PREFIX(set_random_fail)
#define a_random_test IMEM_PREFIX(random_test)
#define a_init_funcs IMEM_PREFIX(init_funcs)
#define a_log_info IMEM_PREFIX(log_info)

#define THROW 	        IMEM_UPREFIX(THROW)
#define NO_THROW 				IMEM_UPREFIX(NO_THROW)
#define YES	 						IMEM_UPREFIX(YES)
#define NO 							IMEM_UPREFIX(NO)
#define OK 							IMEM_UPREFIX(OK)
#define AMB_IN_NODE_POOL	IMEM_UPREFIX(AMB_IN_NODE_POOL)

#define KEEP_AMB 				IMEM_UPREFIX(KEEP_AMB)
#define NO_KEEP_AMB     IMEM_UPREFIX(NO_KEEP_AMB)
#define USE_POOL 				IMEM_UPREFIX(USE_POOL)
#define NO_USE_POOL     IMEM_UPREFIX(NO_USE_POOL)
#define WITH_LOG        IMEM_UPREFIX(WITH_LOG)
#define WITH_NO_LOG     IMEM_UPREFIX(WITH_NO_LOG)
#define WITH_ZB    			IMEM_UPREFIX(WITH_ZB)
#define WITH_NO_ZB    	IMEM_UPREFIX(WITH_NO_ZB)
#define WITH_CUSTOM_CLEANUP	IMEM_UPREFIX(WITH_CUSTOM_CLEANUP)
#define WITH_NO_CUSTOM_CLEANUP	IMEM_UPREFIX(WITH_NO_CUSTOM_CLEANUP)
#define LOG_RANDOM_PROB	IMEM_UPREFIX(LOG_RANDOM_PROB)

#define USE_MSS 				IMEM_UPREFIX(USE_MSS)
#define NO_USE_MSS     IMEM_UPREFIX(NO_USE_MSS)

#define BY_MALLOC 			IMEM_UPREFIX(BY_MALLOC)
#define BY_CALLOC 			IMEM_UPREFIX(BY_CALLOC)
#define BY_REALLOC 			IMEM_UPREFIX(BY_REALLOC)

#define IMEM_MAKE_LOG_NAME(a) #a ".log"
#define IMEM_MAKE_NAME(a) #a
#define IMEM_INIT_FUNCS(mf, flags, malloc, calloc, realloc, free, opaque) \
	imem_init_funcs (mf, flags, malloc, calloc, realloc, free, opaque, \
		#flags, #malloc, #calloc, #realloc, #free)


#endif /* _IMEMDEFS_H_ */
