#ifndef _NODEPOOL_H_
#define _NODEPOOL_H_

#include <stdlib.h>
#include <assert.h>
#include <stdio.h>
#include <string.h>
#include "pmemfunc.h"
#include "imemdbug.h"


#ifdef MSS
#include "mss.h"
#endif

enum {
	NODE_POOL_OK = 1
	};

typedef void * partition_handle;

typedef struct part_type_s {
    void *next;
		struct part_type_s * another;
} part_type;


struct _private_node_pool_t
	{
		int n;
		size_t size;
		partition_handle ph;
		imem_malloc_t pmalloc;
		imem_free_t pfree;
		void * opaque;
	};

#ifdef NODE_POOL_IMPLEMENTATION

typedef struct _private_node_pool_t node_pool_t;

#else

typedef struct _public_node_pool_t
	{
		char foo [sizeof (struct _private_node_pool_t) / sizeof (char)];
	}
node_pool_t;

#endif /* NODE_POOL_OIMPLEMENTATION */


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

int node_pool_init (node_pool_t * np ,imem_malloc_t pmalloc ,imem_free_t pfree ,void * opaque );
int node_pool_create (node_pool_t * np ,int n ,size_t size );
void node_pool_destroy (node_pool_t * np );
void * node_pool_get_node (node_pool_t * const np);
void node_pool_free_node (node_pool_t * np, void *const mem);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _NODEPOOL_H_ */
