#ifndef _IUSER_H_
#define _IUSER_H_

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <math.h>
#include <assert.h>
#include <string.h>
#include <stdarg.h>
#include <ctype.h>

#include "defines.h"

struct _progress_status_s
{
  time_t prev, start, current;
  long totlen;                /* total number of cycles, 0 when finished */
  long rlen;                  /* number of cycles runned so far */
  size_t flags;		      /* appareance options */
  char_t *msg;		      /* what are you doing  */

  /* ACTIVE, INITIALIZED, */
  size_t info;

  /* INIT, START, STEP, END, DEINIT */
  int where;
  int users;

  int percentage;
  double elapsed;
  double to_go;

  /* needed in event-driven enviroments */
  int wait;
  int stop;

  int (*pprogress) (struct _progress_status_s *);  /* user callback */

  void *opaque;               /* user data */
};

struct _log_message_s
{
  char_t * text;
  int dinamic;		/* should be free'd ? */
};

struct _log_s
{
  int (*plog) (struct _log_s *, int);  /* user callback */
  char_t * name;
  char * file;
  size_t line;
  struct _log_message_s msg;
  unsigned int flags;
  void * log_context;	/* contect private to the cb */
  void * opaque;       /* other user data (memory allocator ...) */
};

typedef struct _log_message_s iuser_message_t;
typedef struct _log_s iuser_log_t;
typedef int (*iuser_log_callback_t) (iuser_log_t *, int);  /* user callback */

typedef struct _progress_status_s iuser_progress_t;
typedef int (*iuser_progress_callback_t) (iuser_progress_t *);

typedef FILE stream_t;
typedef int fprintf_t (stream_t *, const char_t *,...);
typedef void * (*iuser_malloc_t)(size_t, void *);
typedef void (*iuser_free_t)(void*, void *);


enum
{
  /* return values */
  IUSER_ERROR = 0,
  IUSER_OK = 1,
  IUSER_TRUE = 0,
  IUSER_FALSE = 1,
  IUSER_INVALID_PARAMETER = -1,
  IUSER_PROGRESS_CAN_CONTINUE = 0,
  IUSER_PROGRESS_STOPPED = -9999
};

enum
{
  /* progress where */
  IUSER_PROGRESS_DEINIT = -2,
  IUSER_PROGRESS_INIT = -1,
  IUSER_PROGRESS_START = 0,
  IUSER_PROGRESS_STEP = 1,
  IUSER_PROGRESS_END = 2
};

enum
{
  IUSER_LOG_DEINIT = -2,
  IUSER_LOG_INIT = -1,
  IUSER_LOG_CLEAR = 1,
  IUSER_LOG_MESSAGE = 2,
  /* flags */
  IUSER_LOG_IS_ACTIVE = 0x00000001
};

enum
{
  IUSER_ERROR_DEINIT   = -2,
  IUSER_ERROR_INIT     = -1,
  IUSER_ERROR_HANDLE   = 2,
  IUSER_ERROR_LOG      = 3,
  IUSER_ERROR_ABORTING = 4,
  IUSER_ERROR_EXITING  = 5,
  /* flags */
  IUSER_ERROR_IS_ACTIVE = 0x00000001,
  IUSER_ERROR_IS_DEINITIALIZED = 0x00000002,
  IUSER_ERROR_IS_INITIALIZED = 0x00000004
};

enum
{
  /* info */
  IUSER_PROGRESS_IS_DEINITIALIZED = 0x00000000,
  IUSER_PROGRESS_IS_STARTED = 0x00000001,
  IUSER_PROGRESS_IS_INITIALIZED = 0x00000004,
  IUSER_PROGRESS_IS_ACTIVE = 0x00000008,
  IUSER_PROGRESS_IS_UPDATED = 0x00000010
};

enum
{
  /* init flags */
  IUSER_PROGRESS_SECONDARY_THREAD = 0x00000002,
  IUSER_PROGRESS_STYLE_SIMPLE = 0x00000100,
  IUSER_PROGRESS_STYLE_PERCENTAGE = 0x00000200,
  IUSER_PROGRESS_STYLE_TIME = 0x00000400,
};

enum
{
  /* usual (?) width of screen */
  IUSER_TEXT_SCREEN_WIDTH = 80
};

#ifdef __cplusplus
extern "C"
{
#endif                          /* __cplusplus */

  extern int iuser_progress (iuser_progress_t *, const char_t *);
  extern int iuser_progress_stdio (iuser_progress_t *);

  extern void iuser_progress_set_length (iuser_progress_t *, size_t);
  extern void iuser_progress_set_type (iuser_progress_t *, int);
  extern void iuser_progress_set_opaque (iuser_progress_t *, void *);
  extern void iuser_progress_set_callback (iuser_progress_t *, int (*)(iuser_progress_t *));
  extern void iuser_progress_set_msg (iuser_progress_t *, const char_t *);
  extern void iuser_progress_set_flags (iuser_progress_t *, int);
  extern char_t *iuser_progress_get_msg (const iuser_progress_t *);
  extern void *iuser_progress_get_opaque (const iuser_progress_t *);
  extern int iuser_progress_get_elapsed_hrs (const iuser_progress_t *);
  extern int iuser_progress_get_elapsed_mins (const iuser_progress_t *);
  extern int iuser_progress_get_elapsed_secs (const iuser_progress_t *);
  extern int iuser_progress_get_remaining_hrs (const iuser_progress_t *);
  extern int iuser_progress_get_remaining_mins (const iuser_progress_t *);
  extern int iuser_progress_get_remaining_secs (const iuser_progress_t *);
  extern int iuser_progress_get_percentage (const iuser_progress_t *);
  extern int iuser_progress_get_flags (const iuser_progress_t *);
  extern int iuser_progress_where (const iuser_progress_t *);
  extern void iuser_progress_activate (iuser_progress_t *);
  extern void iuser_progress_deactivate (iuser_progress_t *);
  extern int iuser_progress_is_active (const iuser_progress_t *);
  extern int iuser_progress_init (iuser_progress_t *, int, iuser_progress_callback_t , void *);
  extern void iuser_progress_deinit (iuser_progress_t *);
  extern void iuser_progress_set_where (iuser_progress_t *, const int);
  extern int iuser_progress_nusers (iuser_progress_t *);
  extern void iuser_progress_set_updated (iuser_progress_t * );
  extern void iuser_progress_reset_updated (iuser_progress_t * );
  extern int iuser_progress_is_updated (const iuser_progress_t * );
  extern int iuser_progress_is_wait (const iuser_progress_t *);
  extern void iuser_progress_set_wait (iuser_progress_t *);
  extern void iuser_progress_reset_wait (iuser_progress_t *);
  extern int iuser_progress_is_stop (const iuser_progress_t *);
  extern void iuser_progress_set_stop (iuser_progress_t *);
  extern void iuser_progress_reset_stop (iuser_progress_t *);
  extern int iuser_progress_is_started (iuser_progress_t * params);
  extern void iuser_progress_set_started (iuser_progress_t * params);
  extern void iuser_progress_reset_started (iuser_progress_t * params);

  extern int iuser_log_init (iuser_log_t *, iuser_log_callback_t, char_t *, void *, void *);
  extern void iuser_log_deinit (iuser_log_t *);
  extern int iuser_log (iuser_log_t *, const char * /* __FILE__ */, size_t /* __LINE__ */, const char_t *, ...);
  extern void iuser_log_activate (iuser_log_t *);
  extern void iuser_log_deactivate (iuser_log_t *);
  extern int iuser_log_is_active (iuser_log_t *);
  extern void iuser_log_clear (iuser_log_t *);
  extern iuser_log_callback_t iuser_log_set_callback (iuser_log_t *, iuser_log_callback_t);
  extern iuser_log_callback_t iuser_log_get_callback (iuser_log_t *);
  extern void * iuser_log_set_opaque (iuser_log_t *, void *);
  extern void * iuser_log_get_opaque (iuser_log_t *);
  extern void * iuser_log_set_context (iuser_log_t *, void *);
  extern void * iuser_log_get_context (iuser_log_t *);
  extern void iuser_vmprintf (iuser_message_t * msg, const char_t * fmt, va_list ap);
  extern void iuser_log_free_message (iuser_message_t *);
  extern char_t *iuser_log_get_message (iuser_log_t * ilog);
  extern size_t iuser_log_get_line (iuser_log_t * ilog);
  extern char * iuser_log_get_file (iuser_log_t * ilog);

  /*
   * extern void iuser_log_clear (iuser_log_t *);
   * extern iuser_log_t * iuser_log_get (iuser_log_t *);
   */

  extern const iuser_message_t * IUSER_LOG_MSG_NO_MEMORY;
  extern const double IUSER_SECS_PER_MIN;
  extern const double IUSER_SECS_PER_HOUR;
  extern iuser_log_t const * g_iuser_log;

#include "error.h"

  extern int iuser_error (iuser_error_t *, iuser_severity_t , int , const char * , size_t, const char_t *, ...);

#ifdef __cplusplus
}
#endif                          /* __cplusplus */

#endif                          /* !_IUSER_H_ */
