#ifdef IUSER_OS_WIN32

#include "iuserw32.h"

static char_t *rcsid = "$Id: iuserw32.c 1.9 2000-08-23 18:20:00+02 fede Exp fede $";


/*
 * TODO:
 * - using a window instead of a control one could easily add it as a
 *   child window ...
 * - UNICODE
 * - timing
 * - use thread specific data for initialization or allow to use a
 *   specific heap for allocation or publish a function for allocating
 *   the space
 * - center dialog in the screen
 * - handle different type of progress
 *
 * $Log: iuserw32.c $
 * Revision 1.9  2000-08-23 18:20:00+02  fede
 * Added a stupid LibMain function
 *
 * Revision 1.8  2000-08-21 18:14:43+02  fede
 * Changed char to char_t to eventually support UNICODE
 *
 * Revision 1.7  2000-08-16 22:40:08+02  fede
 * The Dialog is more beautifull.
 *
 * Revision 1.6  2000-08-15 16:52:31+02  fede
 * Cleaned the code (both estetically and functionally).
 *
 * Revision 1.5  2000-08-15 16:00:45+02  fede
 * iuser_progress_init_w32/iuser_progress_deinit_w32 use iuser_progress_w32
 * to manage neede memory.
 *
 * Revision 1.4  2000-08-15 15:48:16+02  fede
 * Added parameters to init/deinit functions: an allocator,  deallocator and
 * a mamory context are passed.
 *
 * Revision 1.3  2000-08-15 12:03:39+02  fede
 * Support user cancellation request.
 *
 * Revision 1.2  2000-08-15 11:37:53+02  fede
 * Added iuser_progress_w32_init (uses malloc).
 * Added a Peek/Translate/Dispatch message body to the
 * IUSER_PROGRESS_STEP case.
 *
 * Revision 1.1  2000-08-14 17:05:43+02  fede
 * Optimized updates
 *
 * Revision 1.0  2000-08-14 17:01:54+02  fede
 * Initial revision
 *
 */

typedef struct _my_progress_params_w32_s
  {
    HWND hwndPrDlg;
    HWND hwndParent;
  }
iuser_progress_w32_t;

BOOL WINAPI
LibMain (HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved)
{
	// TODO: handle dll initialization
	return TRUE;
}

static BOOL _stdcall
iuser_progress_w32_dlg (HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	iuser_progress_t * status;
  switch (msg)
    {
    case WM_CLOSE:
			goto CANCELLING;
    case WM_COMMAND:
      switch (LOWORD (wParam))
        {
        case IDCANCEL:
CANCELLING:
				// get the status pointer
        	status = (iuser_progress_t *)
								GetWindowLong (hwnd, DWL_USER);
					iuser_progress_set_wait (status);
					// TODO: multilingual message
          if (MessageBox (hwnd, "Do you really want to stop ?", "",
						MB_YESNO) == IDYES)
						{
							iuser_progress_set_stop (status);
				      EndDialog (hwnd, 0);
							iuser_progress_reset_wait (status);
							return 1;
						}
          break;
        }
      break;
    }
  return 0;
}

/*
 * Lacks handling of cancellation
 */
int
iuser_progress_w32 (iuser_progress_t * status)
{
  HWND hPrBar;
  HWND hPrDlg;
  iuser_progress_w32_t *status_opaque;

  status_opaque = (iuser_progress_w32_t *) iuser_progress_get_opaque (status);
  assert (status_opaque != NULL);


  switch (iuser_progress_where (status))
    {
    case IUSER_PROGRESS_INIT:

			DEBUGGING (
				fprintf (stderr, "Initializing ...");
				);

			status_opaque = HeapAlloc (GetProcessHeap (), HEAP_ZERO_MEMORY,
				sizeof (iuser_progress_t));

			if (status_opaque == NULL)
				{
					return IUSER_ERROR;
				}

      /*
       * TODO:
       * - check for dialog succesfull, if not report the
       *   GetLastError results
       */
      /*
       * try to see if the resource is contained in the .exe ...
       */
      status_opaque->hwndPrDlg =
        CreateDialog (GetModuleHandle (NULL),
                      MAKEINTRESOURCE (IUSER_PROGRESS_W32_DLG),
                      status_opaque->hwndParent, iuser_progress_w32_dlg);
      /*
       * ... or if it is in the iuser.dll
       */
      if (status_opaque->hwndPrDlg == NULL)
        {
          status_opaque->hwndPrDlg =
            CreateDialog (GetModuleHandle ("iuser"),
                          MAKEINTRESOURCE (IUSER_PROGRESS_W32_DLG),
                          status_opaque->hwndParent,
                          iuser_progress_w32_dlg);
        }


      if (status_opaque->hwndPrDlg == NULL)
				{
	        MessageBox (GetActiveWindow (),
						"iuser fatal error: "
						"cannot initialize progress dialog", "", MB_OK);
					return IUSER_ERROR;
				}

      //ShowWindow (status_opaque->hwndPrDlg, SW_HIDE);

      assert (GetDlgItem (status_opaque->hwndPrDlg,
				IUSER_PROGRESS_W32_BAR) != NULL);

      SetWindowLong (status_opaque->hwndPrDlg, DWL_USER, (LONG) status);
			iuser_progress_set_opaque (status, status_opaque);

			DEBUGGING (
				fprintf (stderr, "dialog at %p\n", status_opaque->hwndPrDlg);
				);

			return IUSER_OK;

      break;
    case IUSER_PROGRESS_START:
      {
				// the style is available here (?)
        hPrDlg = status_opaque->hwndPrDlg;
        assert (hPrDlg != NULL);
        hPrBar = GetDlgItem (hPrDlg, IUSER_PROGRESS_W32_BAR);
        assert (hPrBar != NULL);

        SetDlgItemText (hPrDlg, IUSER_PROGRESS_W32_TEXT,
                        iuser_progress_get_msg (status));

        SetDlgItemText (hPrDlg, IUSER_PROGRESS_W32_EL_TEXT, _TEXT(""));
        SetDlgItemText (hPrDlg, IUSER_PROGRESS_W32_RE_TEXT, _TEXT(""));
        SetDlgItemText (hPrDlg, IUSER_PROGRESS_W32_PERC_TEXT, _TEXT(""));
        SetDlgItemText (hPrDlg, IUSER_PROGRESS_W32_EL_S_TEXT, _TEXT(""));
        SetDlgItemText (hPrDlg, IUSER_PROGRESS_W32_RE_S_TEXT, _TEXT(""));
				ShowWindow (hPrBar, SW_HIDE);

				if (status->flags & IUSER_PROGRESS_STYLE_SIMPLE)
					{
		        SetDlgItemText (hPrDlg, IUSER_PROGRESS_W32_PERC_TEXT,
							_TEXT("0 %"));
					}
				else
					{
					if (status->flags & IUSER_PROGRESS_STYLE_TIME)
						{
			        SetDlgItemText (hPrDlg, IUSER_PROGRESS_W32_EL_TEXT,
								_TEXT(""));
			        SetDlgItemText (hPrDlg, IUSER_PROGRESS_W32_RE_TEXT,
								_TEXT(""));
			        SetDlgItemText (hPrDlg, IUSER_PROGRESS_W32_EL_S_TEXT,
								_TEXT("Elapsed:"));
			        SetDlgItemText (hPrDlg, IUSER_PROGRESS_W32_RE_S_TEXT,
								_TEXT("Remaining:"));
						}
					if (status->flags & IUSER_PROGRESS_STYLE_PERCENTAGE)
						{
							ShowWindow (hPrBar, SW_SHOW);
						}
					}


				DEBUGGING (
					fprintf (stderr, "dialog at %p\n", status_opaque->hwndPrDlg);
					);

				ShowWindow (hPrDlg, SW_SHOWNOACTIVATE);

        ProgressBar_SetRange (hPrBar, 0, 100);
        ProgressBar_SetStep (hPrBar, 1);

        UpdateWindow (hPrDlg);
      }
			return IUSER_OK;
      break;

    case IUSER_PROGRESS_STEP:
      {
			  MSG msg;
        hPrDlg = status_opaque->hwndPrDlg;
        assert (hPrDlg != NULL);


				// Peek a message
				if (PeekMessage (&msg, hPrDlg, 0, 0, PM_REMOVE))
					{
		        TranslateMessage (&msg);
		        DispatchMessage (&msg);
					}

				if (iuser_progress_is_stop (status))
					{
						DEBUGGING (
							fprintf (stderr, "Stopped!\n");
							);
						iuser_progress_reset_stop (status);
						return IUSER_PROGRESS_STOPPED;
					}

				if (!iuser_progress_is_updated (status))
					return IUSER_PROGRESS_CAN_CONTINUE;


        hPrBar = GetDlgItem (hPrDlg, IUSER_PROGRESS_W32_BAR);
        assert (hPrBar != NULL);

				if (status->flags == IUSER_PROGRESS_STYLE_SIMPLE)
					{
						TCHAR perc[10];

						wsprintf (perc, _TEXT ("%d %%"),
							iuser_progress_get_percentage (status));

            SetDlgItemText (hPrDlg, IUSER_PROGRESS_W32_PERC_TEXT, perc);
					}
        else if (status->flags == IUSER_PROGRESS_STYLE_TIME)
          {
            char_t elapsed[20];
            char_t remaining[20];

            sprintf (elapsed, "%02d:%02d:%02d",
                     iuser_progress_get_elapsed_hrs (status),
                     iuser_progress_get_elapsed_mins (status),
                     iuser_progress_get_elapsed_secs (status));

            sprintf (remaining, "%02d:%02d:%02d",
                     iuser_progress_get_remaining_hrs (status),
                     iuser_progress_get_remaining_mins (status),
                     iuser_progress_get_remaining_secs (status));

            SetDlgItemText (hPrDlg, IUSER_PROGRESS_W32_EL_TEXT, elapsed);
            SetDlgItemText (hPrDlg, IUSER_PROGRESS_W32_RE_TEXT, remaining);

            DEBUGGING (
                        fprintf (stderr, "\r%s, %s", elapsed, remaining);
              );

          }
        else if (status->flags == IUSER_PROGRESS_STYLE_PERCENTAGE)
          {
            ProgressBar_SetPos (hPrBar, iuser_progress_get_percentage (status));
          }
        else if ((status->flags & IUSER_PROGRESS_STYLE_TIME)
                 && (status->flags & IUSER_PROGRESS_STYLE_PERCENTAGE))
          {
            char_t elapsed[20];
            char_t remaining[20];

            sprintf (elapsed, "%02d:%02d:%02d",
                     iuser_progress_get_elapsed_hrs (status),
                     iuser_progress_get_elapsed_mins (status),
                     iuser_progress_get_elapsed_secs (status));

            sprintf (remaining, "%02d:%02d:%02d",
                     iuser_progress_get_remaining_hrs (status),
                     iuser_progress_get_remaining_mins (status),
                     iuser_progress_get_remaining_secs (status));

            SetDlgItemText (hPrDlg, IUSER_PROGRESS_W32_EL_TEXT, elapsed);
            SetDlgItemText (hPrDlg, IUSER_PROGRESS_W32_RE_TEXT, remaining);
            ProgressBar_SetPos (hPrBar,
							iuser_progress_get_percentage (status));
            DEBUGGING (
                        fprintf (stderr, "\r%s, %s", elapsed, remaining);
              );
          }
      }
			return IUSER_PROGRESS_CAN_CONTINUE;
      break;
    case IUSER_PROGRESS_END:
      {
        HWND hwndPrevious;

        hwndPrevious = GetForegroundWindow ();
        hPrDlg = status_opaque->hwndPrDlg;
        assert (hPrDlg != NULL);
        hPrBar = GetDlgItem (hPrDlg, IUSER_PROGRESS_W32_BAR);
        assert (hPrBar != NULL);
        ProgressBar_SetPos (hPrBar, 100);
        ShowWindow (hPrDlg, SW_HIDE);
        ProgressBar_SetPos (hPrBar, 0);
        SetFocus (hwndPrevious);

				return IUSER_OK;

        break;
      }
    case IUSER_PROGRESS_DEINIT:
      // found in Petzold
      SetWindowLong (status_opaque->hwndPrDlg, DWL_USER, (LONG) NULL);
      DestroyWindow (GetParent (hPrBar));
			HeapFree (GetProcessHeap (), 0, status_opaque);
			return IUSER_OK;
      break;
    default:
			DEBUGGING (
				fprintf (stderr, "Callback called with an unknown parameter\n")
				);
			return IUSER_ERROR;
      break;
    }
}

/*
 * TODO:
 * - here should be know the parent for the message box, if possible:
 *   change the parameter
 */
void
iuser_show_w32_error (HINSTANCE hInst)
{
  LPVOID lpMsgBuf;

  FormatMessage (
                FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
                  NULL,
                  GetLastError (),
                  MAKELANGID (LANG_NEUTRAL, SUBLANG_DEFAULT),  // Default language
                   (LPTSTR) & lpMsgBuf,
                  0,
                  NULL
    );

  MessageBox (NULL, lpMsgBuf, "GetLastError", MB_OK | MB_ICONINFORMATION);

  LocalFree (lpMsgBuf);
}


#define _MALLOC(size) alloc (size, mem_context)
#define _FREE(ptr) dealloc (ptr, mem_context)

int
iuser_progress_init_w32 (iuser_progress_t * status, HWND hwndParent)
{
  return iuser_progress_init (status, IUSER_PROGRESS_STYLE_SIMPLE,
                       iuser_progress_w32, hwndParent);

}

void
iuser_progress_deinit_w32 (iuser_progress_t * status)
{
	iuser_progress_deinit (status);
}

#undef _MALLOC
#undef _FREE

#ifdef TEST

#define IDACCEL 100
#define IDM_NEW 200
#define IDM_OPEN 210
#define IDM_SAVE 220
#define IDM_SAVEAS 230
#define IDM_CLOSE 240
#define IDM_PRINT 250
#define IDM_PAGESETUP 260
#define IDM_EXIT 300
#define IDM_ABOUT 500
#define IDMAINMENU 600
#define IDAPPLICON 710
#define IDAPPLCURSOR 810
#define IDS_FILEMENU 2000
#define IDS_HELPMENU 2010
#define IDS_SYSMENU 2030
#define IDM_STATUSBAR 3000

static void
MainWndProc_OnCommand (HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
  switch (id)
    {
      // ---TODO--- Add new menu commands here
      /*@@NEWCOMMANDS@@ */
    case IDM_EXIT:
      PostMessage (hwnd, WM_CLOSE, 0, 0);
      break;
    }
}

static LRESULT CALLBACK
MainWndProc (HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
  switch (msg)
    {
/*@@3->@@ */
    case WM_COMMAND:
      HANDLE_WM_COMMAND (hwnd, wParam, lParam, MainWndProc_OnCommand);
      break;
    case WM_DESTROY:
      PostQuitMessage (0);
      break;
    default:
      return DefWindowProc (hwnd, msg, wParam, lParam);
    }
/*@@3<-@@ */
  return 0;
}


static BOOL
InitApplication (HINSTANCE hInst)
{
  WNDCLASS wc;

  memset (&wc, 0, sizeof (WNDCLASS));
  wc.style = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
  wc.lpfnWndProc = (WNDPROC) MainWndProc;
  wc.hInstance = hInst;
  wc.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
  wc.lpszClassName = "ApplWndClass";
  wc.lpszMenuName = MAKEINTRESOURCE (IDMAINMENU);
  wc.hCursor = LoadCursor (NULL, IDC_ARROW);
  wc.hIcon = LoadIcon (NULL, IDI_APPLICATION);

  if (!RegisterClass (&wc))
    return 0;
/*@@0<-@@ */
  // ---TODO--- Call module specific initialization routines here
  InitCommonControls ();

  return 1;
}


static HWND
CreateApplWndClassWnd (HINSTANCE hInst)
{
  HWND rv;
  rv = CreateWindow ("ApplWndClass",
                     "Click here to see the progress status ...",
  //WS_MINIMIZEBOX | WS_VISIBLE |
                     WS_CLIPSIBLINGS | WS_CLIPCHILDREN |
  //WS_MAXIMIZEBOX | WS_CAPTION |
  //WS_BORDER | WS_SYSMENU |
                     WS_THICKFRAME,
  //WS_ICONIC,
  //CW_USEDEFAULT, 0, CW_USEDEFAULT, 0,
                     10, 10, 100, 100,
                     NULL,
                     NULL,
                     hInst,
                     NULL);

  if (rv == NULL)
    {
      iuser_show_w32_error (hInst);
    }
  return rv;
}


#define START_PROGRESS(i, msg) \
	if (iuser_progress_is_active(&status)) \
  { \
		iuser_progress_add_user (&status); \
		iuser_progress_set_where (&status, IUSER_PROGRESS_START);\
		iuser_progress_set_length (&status, i); \
		iuser_progress (&status, msg); \
	}

#define DO_PROGRESS(i) \
	if (iuser_progress_is_active(&status)) \
	{ \
		iuser_progress_set_where (&status, IUSER_PROGRESS_STEP);\
		iuser_progress_set_length (&status, i); \
		if (iuser_progress (&status, "") == IUSER_PROGRESS_STOPPED) \
			break; \
	}

#define END_PROGRESS() \
	if (iuser_progress_is_active(&status)) \
  { \
		iuser_progress_set_where (&status, IUSER_PROGRESS_END);\
		iuser_progress_set_length (&status, 0); \
		iuser_progress_remove_user (&status); \
		iuser_progress (&status, ""); \
	}

static void
job (iuser_progress_t * _status, long MAX)
{
	long i;
	iuser_progress_t status;

	memcpy (&status, _status, sizeof (iuser_progress_t));

  START_PROGRESS (MAX, "ciclo for (1)");
  for (i = 0; i < MAX; ++i)
    {
      DO_PROGRESS (MAX - i);
    }
  END_PROGRESS ();

}


int
main (int argc, char_t **argv)
{
  long MAX = atoi (argc > 1 ? argv[1] : "200000");
  iuser_progress_t status;
  long i;
  HWND hwndMain;                //Main window handle

  printf ("MAX: %ld\n", MAX);

  memset (&status, 0, sizeof (status));

  assert (GetModuleHandle (NULL) != NULL);
  assert (InitApplication (GetModuleHandle (NULL)));
  assert ((hwndMain = CreateApplWndClassWnd (GetModuleHandle (NULL)))
          != (HWND) 0);
  ShowWindow (hwndMain, SW_SHOWNOACTIVATE);

	if (iuser_progress_init_w32 (&status, hwndMain) != IUSER_OK)
		{
			MessageBox (hwndMain, "Cannot initialize the progress library",
				"iuserw32", MB_OK);
		}

	//iuser_progress_deactivate (&status);

  fprintf (stderr, "\n--\n");
  START_PROGRESS (MAX, "ciclo for (SIMPLE)...");
  for (i = 0; i < MAX; ++i)
    {
			//job (&status, MAX / 10000);
      DO_PROGRESS (MAX - i);
    }
  END_PROGRESS ();

  fprintf (stderr, "\n--\n");
  iuser_progress_set_type (&status, IUSER_PROGRESS_STYLE_TIME);

  START_PROGRESS (MAX, "ciclo for (TIME)...");
  for (i = 0; i < MAX; ++i)
    {
      DO_PROGRESS (MAX - i);
    }
  END_PROGRESS ();

  fprintf (stderr, "\n--\n");
  iuser_progress_set_type (&status, IUSER_PROGRESS_STYLE_PERCENTAGE);

  START_PROGRESS (MAX, "ciclo for (PERCENTAGE)...");
  for (i = 0; i < MAX; ++i)
    {
      DO_PROGRESS (MAX - i);
    }
  END_PROGRESS ();

  fprintf (stderr, "\n--\n");
  iuser_progress_set_type (&status,
               IUSER_PROGRESS_STYLE_TIME | IUSER_PROGRESS_STYLE_PERCENTAGE);

  START_PROGRESS (MAX, "ciclo for (TIME | PERCENTAGE)...");
  for (i = 0; i < MAX; ++i)
    {
      DO_PROGRESS (MAX - i);
    }
  END_PROGRESS ();

	iuser_progress_deinit_w32 (&status);

  return 0;
}

#endif /* TEST */

#endif /* IUSER_OS_WIN32 */
