#include "iuser.h"

static int
my_log (iuser_log_t * ilog, int why)
{

	switch (why)
		{
			case IUSER_LOG_INIT:
				assert ((FILE *) iuser_log_get_context (ilog) == stdout);
				break;
			case IUSER_LOG_DEINIT:
				break;
			case IUSER_LOG_MESSAGE:
				fputs ((char*) iuser_log_get_name (g_iuser_log),
					(FILE *) iuser_log_get_context (ilog));
				fputs (":", (FILE *) iuser_log_get_context (ilog));
				fputs ((char*) iuser_log_get_message (ilog),
					(FILE *) iuser_log_get_context (ilog));
				fputs ("\n", iuser_log_get_context (ilog));
				break;
		}
	return IUSER_OK;
}

int
main (int argc, char ** argv)
{
	iuser_log_init (g_iuser_log, my_log, argv[0], (void *) stdout, NULL);

	iuser_log (g_iuser_log, __FILE__, __LINE__,
		"This is a log from line %d of file %s", __LINE__, __FILE__);

	iuser_log_deactivate (g_iuser_log);

	if (iuser_log_is_active (g_iuser_log))
		iuser_log (g_iuser_log, __FILE__, __LINE__,
			"This is a log from line %d of file %s: it shouldn' appear!",
			__LINE__, __FILE__);

	iuser_log_activate (g_iuser_log);

	iuser_log (g_iuser_log, __FILE__, __LINE__, "This should appear!");

	iuser_log_deinit (g_iuser_log);

	return EXIT_SUCCESS;
}

