# =============================================================================
#  Makefile for For2R test driver program     M.H.Prager   mike.prager@noaa.gov
#
#  This file works with OPUS make and the Lahey/Fujitsu LF95 compiler.
#  While some of the nice OPUS features have been avoided to ease porting,
#  USER WILL NEED TO REVISE THIS FILE TO WORK WITH HIS/HER CONFIGURATION
# =============================================================================
#  NOTE: Use of trade names does not imply government endorsement.
#  No warranty is offered or implied.
# =============================================================================

# Macros for compiling and linking
FC     = lf95
LINK   = lf95
FFLAGS = -nco -tp -c -o2 -wo -chk (a,e,s,u,x) -trace -f95 -warn -file
LFLAGS = -nco -tp -nomap
OBJS   =  for2r-test.obj for2r.obj

# Inference rule for Fortran-90:
%.obj : %.f90
	$(FC) $(FFLAGS) $<

for2r-test.exe: $(OBJS)
        $(LINK) $** -out $@ $(LFLAGS)

# Module dependencies:
for2r-test.obj: for2r.obj

clean:      # OPUS: Start shell lines with "--" to ignore returned error code(s) and not warn
        --del /e /f *.lib
        --del /e /f *.mod
        --del /e /f *.obj
        --del /e /f *.exe
        --del /e /f for2rtest.rdat
        @echo *** Object and executable files in this directory deleted.
# =============================================================================
