% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh_aseba.R
\name{compute_mh_p_abcl__critic_sum}
\alias{compute_mh_p_abcl__critic_sum}
\title{Compute "Adult Behavior Checklist [Parent] (Critical items): Sum"}
\usage{
compute_mh_p_abcl__critic_sum(
  data,
  name = "mh_p_abcl__critic_sum",
  max_na = 1,
  exclude = c("777", "999"),
  combine = TRUE
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{name}{character. Name of the summary score column.}

\item{max_na}{numeric, positive whole number. Number of missing items
allowed. \code{NULL} means no limit.}

\item{exclude}{character vector. Values to be excluded from the summary score.}

\item{combine}{logical. If \code{TRUE} (default), the summary score is
is appended as a new column to the input data frame. If \code{FALSE}, the
summary score is returned as a separate one-column data frame.}
}
\value{
tbl. see \code{combine}.
}
\description{
Computes the summary score \code{mh_p_abcl__critic_sum}
Adult Behavior Checklist [Parent] (Critical items): Sum
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{mh_p_abcl__rule_001}
\item \code{mh_p_abcl__attn__adhd_002}
\item \code{mh_p_abcl__tho_001}
\item \code{mh_p_abcl__othpr__adhd_001}
\item \code{mh_p_abcl__anxdep__dep_001}
\item \code{mh_p_abcl__aggr__antsoc_003}
\item \code{mh_p_abcl__tho__dep_001}
\item \code{mh_p_abcl__othpr__antsoc_001}
\item \code{mh_p_abcl__tho_002}
\item \code{mh_p_abcl__aggr_001}
\item \code{mh_p_abcl__aggr__antsoc_006}
\item \code{mh_p_abcl__tho_003}
\item \code{mh_p_abcl__tho_004}
\item \code{mh_p_abcl__tho_006}
\item \code{mh_p_abcl__rule_002}
\item \code{mh_p_abcl__tho__dep_002}
\item \code{mh_p_abcl__rule__antsoc_007}
\item \code{mh_p_abcl__aggr__antsoc_008}
\item \code{mh_p_abcl__anxdep__dep_004}
}
\item \emph{Excluded values:}
\itemize{
\item 777
\item 999
}
\item \emph{Validation criterion:} maximally 1 of 19 items missing
}
}
\examples{
\dontrun{
compute_mh_p_abcl__critic_sum(data) |>
  select(
    any_of(c("mh_p_abcl__critic_sum", vars_mh_p_abcl__critic))
  )
}
}
\seealso{
\code{\link[=compute_mh_p_abcl__critic_nm]{compute_mh_p_abcl__critic_nm()}}
}
