% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh_aseba.R
\name{compute_mh_y_ysr_tscore}
\alias{compute_mh_y_ysr_tscore}
\title{Compute "Youth Self Report [Youth]: T-score"}
\usage{
compute_mh_y_ysr_tscore(
  data,
  data_norm = NULL,
  name = "mh_y_ysr_tscore",
  col_age = "mh_y_ysr_age",
  col_sex = "ab_g_stc__cohort_sex",
  max_na = 7,
  exclude = c("777", "999"),
  combine = TRUE
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{data_norm}{tbl. Data frame containing the norm (T-score) values.
see \code{\link[=ss_tscore]{ss_tscore()}}.}

\item{name}{character. Name of the summary score column.}

\item{col_age}{character, name of the age column. see \code{\link[=ss_tscore]{ss_tscore()}}.}

\item{col_sex}{character, name of the sex column. see \code{\link[=ss_tscore]{ss_tscore()}}.}

\item{max_na}{numeric, positive whole number. Number of missing items
allowed. \code{NULL} means no limit.}

\item{exclude}{character vector. Values to be excluded from the summary score.}

\item{combine}{logical. If \code{TRUE} (default), the summary score is
is appended as a new column to the input data frame. If \code{FALSE}, the
summary score is returned as a separate one-column data frame.}
}
\value{
tbl. see \code{combine}.
}
\description{
Computes the summary score \code{mh_y_ysr_tscore}
Youth Self Report [Youth]: T-score
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{mh_y_ysr__attn__adhd_001}
\item \code{mh_y_ysr__attn__adhd_002}
\item \code{mh_y_ysr__attn__adhd_003}
\item \code{mh_y_ysr__attn__adhd_004}
\item \code{mh_y_ysr__attn__adhd_005}
\item \code{mh_y_ysr__othpr__adhd_001}
\item \code{mh_y_ysr__aggr__adhd_001}
\item \code{mh_y_ysr__soc__anx_001}
\item \code{mh_y_ysr__anxdep__anx_001}
\item \code{mh_y_ysr__anxdep__anx_002}
\item \code{mh_y_ysr__anxdep__anx_003}
\item \code{mh_y_ysr__anxdep__anx_004}
\item \code{mh_y_ysr__som__anx_001}
\item \code{mh_y_ysr__anxdep__anx_005}
\item \code{mh_y_ysr__anxdep__anx_006}
\item \code{mh_y_ysr__anxdep__anx_007}
\item \code{mh_y_ysr__aggr__cond_001}
\item \code{mh_y_ysr__aggr__cond_002}
\item \code{mh_y_ysr__rule__cond_001}
\item \code{mh_y_ysr__rule__cond_002}
\item \code{mh_y_ysr__aggr__cond_003}
\item \code{mh_y_ysr__rule__cond_003}
\item \code{mh_y_ysr__rule__cond_004}
\item \code{mh_y_ysr__aggr__cond_004}
\item \code{mh_y_ysr__rule__cond_005}
\item \code{mh_y_ysr__rule__cond_006}
\item \code{mh_y_ysr__rule__cond_007}
\item \code{mh_y_ysr__rule__cond_008}
\item \code{mh_y_ysr__rule__cond_009}
\item \code{mh_y_ysr__aggr__cond_005}
\item \code{mh_y_ysr__rule__cond_010}
\item \code{mh_y_ysr__wthdep__dep_001}
\item \code{mh_y_ysr__anxdep__dep_001}
\item \code{mh_y_ysr__tho__dep_001}
\item \code{mh_y_ysr__othpr__dep_001}
\item \code{mh_y_ysr__anxdep__dep_002}
\item \code{mh_y_ysr__anxdep__dep_003}
\item \code{mh_y_ysr__som__dep_001}
\item \code{mh_y_ysr__tho__dep_002}
\item \code{mh_y_ysr__othpr__dep_002}
\item \code{mh_y_ysr__anxdep__dep_004}
\item \code{mh_y_ysr__tho__dep_003}
\item \code{mh_y_ysr__wthdep__dep_002}
\item \code{mh_y_ysr__wthdep__dep_003}
\item \code{mh_y_ysr__aggr__opp_001}
\item \code{mh_y_ysr__aggr__opp_002}
\item \code{mh_y_ysr__aggr__opp_003}
\item \code{mh_y_ysr__aggr__opp_004}
\item \code{mh_y_ysr__aggr__opp_005}
\item \code{mh_y_ysr__som__somat_001}
\item \code{mh_y_ysr__som__somat_002}
\item \code{mh_y_ysr__som__somat_003}
\item \code{mh_y_ysr__som__somat_004}
\item \code{mh_y_ysr__som__somat_005}
\item \code{mh_y_ysr__som__somat_006}
\item \code{mh_y_ysr__som__somat_007}
\item \code{mh_y_ysr__aggr_001}
\item \code{mh_y_ysr__aggr_002}
\item \code{mh_y_ysr__aggr_003}
\item \code{mh_y_ysr__aggr_004}
\item \code{mh_y_ysr__aggr_005}
\item \code{mh_y_ysr__aggr_006}
\item \code{mh_y_ysr__anxdep_001}
\item \code{mh_y_ysr__anxdep_002}
\item \code{mh_y_ysr__attn_001}
\item \code{mh_y_ysr__attn_002}
\item \code{mh_y_ysr__attn_003}
\item \code{mh_y_ysr__attn_004}
\item \code{mh_y_ysr__rule_001}
\item \code{mh_y_ysr__rule_002}
\item \code{mh_y_ysr__rule_003}
\item \code{mh_y_ysr__rule_004}
\item \code{mh_y_ysr__rule_005}
\item \code{mh_y_ysr__wthdep_001}
\item \code{mh_y_ysr__wthdep_002}
\item \code{mh_y_ysr__wthdep_003}
\item \code{mh_y_ysr__wthdep_004}
\item \code{mh_y_ysr__wthdep_005}
\item \code{mh_y_ysr__som_001}
\item \code{mh_y_ysr__othpr_001}
\item \code{mh_y_ysr__othpr_002}
\item \code{mh_y_ysr__othpr_003}
\item \code{mh_y_ysr__othpr_004}
\item \code{mh_y_ysr__othpr_005}
\item \code{mh_y_ysr__othpr_006}
\item \code{mh_y_ysr__othpr_007}
\item \code{mh_y_ysr__soc_001}
\item \code{mh_y_ysr__soc_002}
\item \code{mh_y_ysr__soc_003}
\item \code{mh_y_ysr__soc_004}
\item \code{mh_y_ysr__soc_005}
\item \code{mh_y_ysr__soc_006}
\item \code{mh_y_ysr__soc_007}
\item \code{mh_y_ysr__soc_008}
\item \code{mh_y_ysr__soc_009}
\item \code{mh_y_ysr__soc_010}
\item \code{mh_y_ysr__tho_001}
\item \code{mh_y_ysr__tho_002}
\item \code{mh_y_ysr__tho_003}
\item \code{mh_y_ysr__tho_004}
\item \code{mh_y_ysr__tho_005}
\item \code{mh_y_ysr__tho_006}
\item \code{mh_y_ysr__tho_007}
\item \code{mh_y_ysr__tho_008}
\item \code{mh_y_ysr__tho_009}
}
\item \emph{Excluded values:}
\itemize{
\item 777
\item 999
}
\item \emph{Validation criterion:} maximally 7 of 105 items missing
}
}
\examples{
\dontrun{
compute_mh_y_ysr_tscore(data) |>
  select(
    any_of(c("mh_y_ysr_tscore", vars_mh_y_ysr))
  )
}
}
\seealso{
\code{\link[=compute_mh_y_ysr_nm]{compute_mh_y_ysr_nm()}}
}
