% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admm.rpca.R
\name{admm.rpca}
\alias{admm.rpca}
\title{Robust Principal Component Analysis}
\usage{
admm.rpca(M, lambda = 1/sqrt(max(nrow(M), ncol(M))), mu = 1, tol = 1e-07,
  maxiter = 1000)
}
\arguments{
\item{M}{an \eqn{(m\times n)} data matrix}

\item{lambda}{a regularization parameber}

\item{mu}{an augmented Lagrangian parameter}

\item{tol}{relative tolerance stopping criterion}

\item{maxiter}{maximum number of iterations}
}
\value{
a named list containing \describe{
\item{L}{an \eqn{(m\times n)} low-rank matrix}
\item{S}{an \eqn{(m\times n)} sparse matrix}
\item{history}{dataframe recording iteration numerics. See the section for more details.}
}
}
\description{
Given a data matrix \eqn{M}, it finds a decomposition
\deqn{min~\|L\|_*+\lambda \|S\|_1\quad \textrm{s.t.}\quad L+S=M}
where \eqn{\|L\|_*} represents a nuclear norm for a matrix \eqn{L} and
\eqn{\|S\|_1 = \sum |S_{i,j}|}, and \eqn{\lambda} a balancing/regularization
parameter. The choice of such norms leads to impose \emph{low-rank} property for \eqn{L} and
\emph{sparsity} on \eqn{S}.
}
\section{Iteration History}{

For RPCA implementation, we chose a very simple stopping criterion
\deqn{\|M-(L_k+S_k)\|_F \le tol*\|M\|_F}
for each iteration step \eqn{k}. So for this method, we provide a vector of only relative errors,
\describe{
\item{error}{relative error computed}
}
}

\examples{
## generate data matrix from standard normal
X = matrix(rnorm(100*50),nrow=50)

## try different regularization values
out1 = admm.rpca(X, lambda=0.01)
out2 = admm.rpca(X, lambda=0.1)
out3 = admm.rpca(X, lambda=1)

## visualize sparsity
par(mfrow=c(1,3))
image(out1$S, main="lambda=0.01")
image(out2$S, main="lambda=0.1")
image(out3$S, main="lambda=1")

}
\references{
\insertRef{candes_robust_2011}{ADMM}
}
