\name{plotPD} 
\alias{plotPD} 
\title{Plots a calibrated PD of a single date, or SPD of multiple dates, or multiple SPDs} 
\description{Generates a basic plot of the Probability Distribution of calibrated date, or Summed Probability Distribution of multiple calibrated dates, or multiple SPDs such as a data frame of phases.}
\usage{plotPD(x)}
\arguments{
  \item{x}{
	A data frame comprising row names of calendar years and optional column names. For example a one-column dataframe generated by \code{\link[=summedCalibrator]{summedCalibrator}} or a multi-column dataframe generated by \code{\link[=phaseCalibrator]{phaseCalibrator}} 
	}
}
\details{
	Presents the probability density as a grey polygon.
	}
\examples{
	data <- data.frame(age=c(9144),sd=c(151))
	CalArray <- makeCalArray(intcal20,calrange=c(8000,13000))
	cal <- summedCalibrator(data, CalArray)
	plotPD(cal)
	}
