% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ADSIHT.ML.R
\name{ADSIHT.ML}
\alias{ADSIHT.ML}
\title{ADSIHT in multi-task learning framework}
\usage{
ADSIHT.ML(
  x_list,
  y_list,
  group_list,
  s0,
  kappa = 0.9,
  ic.type = c("dsic", "loss"),
  ic.scale = 3,
  ic.coef = 3,
  L = 5,
  weight,
  coef1 = 1,
  coef2 = 1,
  eta = 0.8,
  max_iter = 20,
  method = "ols",
  center = TRUE,
  scale = 1
)
}
\arguments{
\item{x_list}{The list of input matrix.}

\item{y_list}{The list of response variable.}

\item{group_list}{A vector indicating which group each variable belongs to
For variables in the same group, they should be located in adjacent columns of \code{x}
and their corresponding index in \code{group} should be the same.
Denote the first group as \code{1}, the second \code{2}, etc.}

\item{s0}{A vector that controls the degrees with group.
Default is \eqn{d^((l-1)/(L-1))} : \eqn{1 \leq l \leq L}, where d is the maximum group size.}

\item{kappa}{A parameter that controls the rapid of the decrease of threshold. Default is 0.9.}

\item{ic.type}{The type of criterion for choosing the support size.
Available options are \code{"dsic"}, \code{"loss"}.
Default is \code{"dsic"}.}

\item{ic.scale}{A non-negative value used for multiplying the penalty term
in information criterion. Default: \code{ic.scale = 3}.}

\item{ic.coef}{A non-negative value used for multiplying the penalty term
for choosing the optimal stopping time. Default: \code{ic.coef = 3}.}

\item{L}{The length of the sequence of s0. Default: \code{L = 5}.}

\item{weight}{The weight of the samples, with the default value set to 1 for each sample.}

\item{coef1}{A positive value to control the sub-optimal stopping time.}

\item{coef2}{A positive value to control the overall stopping time. A small value leads to larger search range.}

\item{eta}{A parameter controls the step size in the gradient descent step.
Default: \code{eta = 0.8}.}

\item{max_iter}{A parameter that controls the maximum number of line search, ignored if \code{OLS} is employed.}

\item{method}{Whether \code{ols} (default) or \code{linesearch} method should be employed.}

\item{center}{A boolean value indicating whether centralization is required. Default: \code{center = TRUE}.}

\item{scale}{A positive value to control the column-wise L2 norm of each observation matrix. Default: \code{scale=1}.}
}
\value{
A \code{list} object comprising:
\item{beta}{A \eqn{p}-by-\code{length(s0)} matrix of coefficients, stored in column format.}
\item{intercept}{A \code{length(s0)} vector of intercepts.}
\item{lambda}{A \code{length(s0)} vector of threshold values}
\item{A_out}{The selected variables given threshold value in \code{lambda}.}
\item{ic}{The values of the specified criterion for each fitted model given threshold \code{lamdba}.}
}
\description{
An implementation of the sparse group selection in linear regression model via ADSIHT.
}
\examples{
set.seed(1)
n <- 200
p <- 100
K <- 4
s <- 5
s0 <- 2
x_list <- lapply(1:K, function(x) matrix(rnorm(n*p, 0, 1), nrow = n))
vec <- rep(0, K * p)
non_sparse_groups <- sample(1:p, size = s, replace = FALSE)
for (group in non_sparse_groups) {
 group_indices <- seq(group, K * p, by = p)
 non_zero_indices <- sample(group_indices, size = s0, replace = FALSE)
 vec[non_zero_indices] <- rep(2, s0)
}
y_list <- lapply(1:K, function(i) return(
  y = x_list[[i]] \%*\% vec[((i-1)*p+1):(i*p)]+rnorm(n, 0, 0.5))
)
fit <- ADSIHT.ML(x_list, y_list)
fit$A_out[, which.min(fit$ic)]
}
\author{
Yanhang Zhang, Zhifan Li, Shixiang Liu, Jianxin Yin.
}
