% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIGHT.R
\name{MIGHT}
\alias{MIGHT}
\title{MIGHT: Milti-task iterative graphical hard thresholding}
\usage{
MIGHT(
  X,
  ic.coef = 3,
  ic.scale = 3,
  L = 15,
  coef1 = 1,
  coef2 = 0.1,
  kappa = 0.9,
  eta = 0.8,
  center = TRUE,
  scale = 1,
  parallel = FALSE,
  ncpus = 4
)
}
\arguments{
\item{X}{The list of input observation matrices.}

\item{ic.coef}{A non-negative value used for multiplying the penalty term
for choosing the optimal stopping time. Default: \code{ic.coef = 3}.}

\item{ic.scale}{A non-negative value used for multiplying the penalty term
in information criterion. Default: \code{ic.scale = 3}.}

\item{L}{The length of the sequence of s0. Default: \code{L = 15}.}

\item{coef1}{A positive value to control the sub-optimal stopping time.}

\item{coef2}{A positive value to control the overall stopping time. A small value leads to larger search range.}

\item{kappa}{A parameter that controls the rapid of the decrease of threshold. Default is 0.9.}

\item{eta}{A parameter controls the step size in the gradient descent step.
Default: \code{eta = 0.8}.}

\item{center}{A boolean value indicating whether centralization is required. Default: \code{center = TRUE}.}

\item{scale}{A positive value to control the column-wise L2 norm of each observation matrix. Default: \code{scale=1}.}

\item{parallel}{A boolean value indicating whether parallel operation is required. Default: \code{parallel = FALSE}.}

\item{ncpus}{A positive value that controls the numer of cpus. Default: \code{ncpus = 4}.}
}
\value{
A \code{list} object containing the estimated precision matrices for each dataset.
}
\description{
An implementation of the sparse group selection in joint graphical model.
}
\examples{
library(mvnfast)
set.seed(1)
n = 50; p = 10; K = 4
x_list <- lapply(1:K, function(x) rmvn(n, mu=rep(1, p),
                                       sigma = toeplitz( (x/2/K)^(1:p-1) ) ) )
fit = MIGHT(X=x_list, scale = 10)
solve( toeplitz( 0.5^(0:9) ) )
fit[[4]]

}
\author{
Yanhang Zhang, Zhifan Li, Shixiang Liu, Jianxin Yin.
}
