% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finite_diff.R
\name{finite_diff}
\alias{finite_diff}
\title{Finite difference method}
\usage{
finite_diff(f, wrt = NULL, at, h = 1e-08, seed, method = "forward")
}
\arguments{
\item{f}{A function of which the derivative is sought.}

\item{wrt}{Character vector; the name of the variables to differentiate with respect to.}

\item{at}{A named list of variables; the point at which the derivative is evaluated.}

\item{h}{The finite differencing parameter; the size of perturbation.}

\item{seed}{Seed; for pathwise derivative only.}

\item{method}{"forward" for forward differencing or "central" for central differencing.}
}
\value{
A numeric matrix; the Jacobian matrix.
}
\description{
Finite difference method
}
\examples{
f <- function(y, X, beta) { y - X \%*\% beta }
finite_diff(
  f, wrt = "beta",
  at = list(X = matrix(1:4, 2, 2), y = c(2, 3), beta = c(5, 6))
)

g <- function(X, Y) { X \%*\% Y }
finite_diff(g, at = list(X = randn(2, 2), Y = randn(2, 2)))

h <- function(x) { exp(-x^2) }
finite_diff(h, at = list(x = 0.01), wrt = "x")
finite_diff(h, at = list(x = 0.01), wrt = "x", method = "central")

}
