% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFMReportMaker.R
\name{generateCheckReport}
\alias{generateCheckReport}
\title{Generate a check report for one AFMImage}
\usage{
generateCheckReport(AFMImage)
}
\arguments{
\item{AFMImage}{an \code{\link{AFMImage}} imported from Nanoscope Analysis(TM) with \code{\link{importFromNanoscope}} or created manually \code{\link{AFMImage}}}
}
\description{
Generate a check report in pdf format in order to analyse the distribution and the isotropy of heights of the \code{\link{AFMImage}}.
}
\examples{
\dontrun{
library(AFM)

# Analyse the AFMImageOfRegularPeaks AFMImage sample from this package
  data("AFMImageOfRegularPeaks")
  AFMImage<-AFMImageOfRegularPeaks
# exportDirectory="C:/Users/my_windows_login" or exportDirectory="/home/ubuntu"
  exportDirectory=tempdir()
  AFMImage@fullfilename<-paste(exportDirectory,"AFMImageOfRegularPeaks.txt",sep="/")
  
# Start to check if your sample is normaly distributed and isotropic.
  generateCheckReport(AFMImage)
# If the sample is normaly distributed and isotropic, generate a full report
  generateReport(AFMImage)

# Analyse your own AFM image from nanoscope analysis (TM) software tool
   anotherAFMImage<-importFromNanoscope("c:/users/me/myimage.txt")
# Start to check if your sample is normaly distributed and isotropic.
   generateCheckReport(anotherAFMImage)
# If your sample is normaly distributed and isotropic, generate a full report
   generateReport(anotherAFMImage)
}
}
\author{
M.Beauvais
}
