% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/aj.R
\name{aj}
\alias{aj}
\title{aj}
\usage{
aj(times, data, param)
}
\arguments{
\item{times}{a vector of evaluation times}

\item{data}{data frame (see \code{\link{etm}} function documentation)}

\item{param}{list of parameters (target, states, transitions, censoring, s, t, covariance) (see \link{etm} documentation)}
}
\value{
a list containing
 \item{times}{the argument \code{times} passed to the function}
 \item{S}{vector of 1 minus transition probabilities at \code{times} (one for each element of \code{times})}
 \item{V}{vector of variances at 'times' (only if \code{param$cov} is TRUE)}
 \item{logCOV}{matrix containing estimated values of the log-covariance function evaluated for all pairs of elements of the vector \code{times} (only if \code{param$cov} is TRUE and model is a competing risks model)}
}
\description{
Aalen-Johansen estimator (empirical transition matrix)
}
\details{
Wrapper for 'etm' function from the 'etm' package to be used with \code{\link{ahrAJ}}

For a description of the parameters in the list \code{param} see the documentation of the \code{\link{etm}} function in package \code{etm}.
}
\examples{
## competing risks
T <- rexp(100)
C <- rexp(100)
r <- rbinom(100, 2, 0.5)
r[(r == 0) | (T > C)] <- "cens"
data <- data.frame(id=1:100, time=pmin(T,C), from=rep(0, 100), to=r)
data <- data[order(data$time),]
tra <- matrix(FALSE, nrow=3, ncol=3)
tra[1, 2:3] <- TRUE
# estimate cumulative incidence function for event type 1
fit <- aj(sort(data$time), data, list(target="0 1", states=c("0", "1", "2"), transitions=tra,
   censoring="cens", s=0, t="last", covariance=TRUE))
}
\seealso{
\code{\link[etm]{etm}}
}

