% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastkm.R
\name{fastkm}
\alias{fastkm}
\title{fastkm}
\usage{
fastkm(time, status, ltrunc = rep.int(0, length(time)), left.limit = FALSE,
  eval = time)
}
\arguments{
\item{time}{vector of right-censored survival times}

\item{status}{censoring indicator for each element of \code{time} (0 = right-censored, 1 = event)}

\item{ltrunc}{vector of left-truncation times}

\item{left.limit}{indicates wether estimated survival function is left continuous}

\item{eval}{points at which the estimated survival function should be evaluated}
}
\value{
A list containing the vectors \code{time}, \code{surv} and \code{variance}, and \code{n.atrisk}
}
\description{
Fast Kaplan-Meier estimator
}
\details{
This function calculates the Kaplan-Meier estimator for right-censored survival data,
at arbitrary time points. It can handle left-truncated and/or right-censored data with ties.
Avoids the overhead of the \code{survfit} or \code{prodlim} functions by stripping
away most of the features not needed here.
}
\examples{
T <- rexp(100)
C <- rexp(100)
Y <- pmin(T, C)
D <- T <= C
sort(fastkm(Y, D)$surv, decreasing=TRUE)
# should be exactly the same as
fit <- survfit(Surv(Y, D) ~ 1)
f <- approxfun(fit$time, fit$surv, f=0, rule=2, yleft=1)
f(fit$time)
}
\seealso{
\code{\link{survfit}} and \code{\link[prodlim]{prodlim}}
}

