% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{fill_intensity}
\alias{fill_intensity}
\title{Construct intensity profile for a given particle trajectory}
\usage{
fill_intensity(len_t, M, I, pos, Ic, sz, sigma_p)
}
\arguments{
\item{len_t}{number of time steps}

\item{M}{number of particles}

\item{I}{background intensity profile. See 'Details'.}

\item{pos}{position matrix for particle trajectory}

\item{Ic}{vector of maximum intensity of each particle}

\item{sz}{frame size of simulated square image}

\item{sigma_p}{radius of the spherical particle (3sigma_p)}
}
\value{
Intensity profile matrix with structure 'T_SS_mat' (matrix with
dimension \code{len_t} by \code{sz}\eqn{\times}{\%\times}\code{sz}).
}
\description{
Construct intensity profile with structure 'T_SS_mat' for a given particle
trajectory, background intensity profile, and user defined radius of particle.
}
\details{
Input \code{I} should has structure 'T_SS_mat', matrix with dimension
\code{len_t} by \code{sz}\eqn{\times}{\%\times}\code{sz}.

Input \code{pos} should be the position matrix with dimension
\code{M}\eqn{\times}{\%\times}\code{len_t}. See \code{\link{bm_particle_intensity}},
\code{\link{ou_particle_intensity}}, \code{\link{fbm_particle_intensity}},
\code{\link{fbm_ou_particle_intensity}}.
}
\references{
Gu, M., He, Y., Liu, X., & Luo, Y. (2023). Ab initio uncertainty
quantification in scattering analysis of microscopy.
arXiv preprint arXiv:2309.02468.

Gu, M., Luo, Y., He, Y., Helgeson, M. E., & Valentine, M. T. (2021).
Uncertainty quantification and estimation in differential dynamic microscopy.
Physical Review E, 104(3), 034610.
}
\author{
\packageAuthor{AIUQ}
}
\keyword{internal}
