% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plot_MSD}
\alias{plot_MSD}
\title{Plot estimated MSD with uncertainty from SAM class}
\usage{
plot_MSD(object, msd_truth = NA, title = NA, log10 = TRUE)
}
\arguments{
\item{object}{an S4 object of class \code{SAM}}

\item{msd_truth}{a vector of true MSD or reference MSD value, default is \code{NA}}

\item{title}{main title of the plot. If \code{NA}, title is "model_name" with
\code{model_name} being a field in \code{SAM} class representing fitted model.}

\item{log10}{a logical evaluating to TRUE or FALSE indicating whether a plot
in log10 scale is generated}
}
\value{
A plot of estimated MSD with uncertainty versus truth/reference values.
}
\description{
Function to plot estimated MSD with uncertainty from \code{SAM} class, versus
true mean squared displacement(MSD) or given reference values.
}
\examples{
library(AIUQ)

## Simulate BM and get estimated parameters with uncertainty using BM model
# Simulation
sim_bm = simulation(sz=100,len_t=100,sigma_bm=0.5)
show(sim_bm)

# AIUQ method: fitting using BM model with a reduced range
sam = SAM(sim_object=sim_bm, uncertainty=TRUE,AIUQ_thr=c(0.999,0.5))
show(sam)

plot_MSD(object=sam, msd_truth=sam@msd_truth) #in log10 scale
#plot_MSD(object=sam, msd_truth=sam@msd_truth,log10=FALSE) #in real scale

}
\references{
Gu, M., He, Y., Liu, X., & Luo, Y. (2023). Ab initio uncertainty
quantification in scattering analysis of microscopy.
arXiv preprint arXiv:2309.02468.

Gu, M., Luo, Y., He, Y., Helgeson, M. E., & Valentine, M. T. (2021).
Uncertainty quantification and estimation in differential dynamic microscopy.
Physical Review E, 104(3), 034610.
}
\author{
\packageAuthor{AIUQ}
}
