% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Crop.R
\docType{methods}
\name{crop}
\alias{crop}
\title{Crop voxel space}
\usage{
crop(vxsp, imin = 0, imax = Inf, jmin = 0, jmax = Inf, kmin = 0, kmax = Inf)
}
\arguments{
\item{vxsp}{a \code{\linkS4class{VoxelSpace}} object.}

\item{imin}{minimum i index of cropped area (inclusive)}

\item{imax}{maximum i index of cropped area (inclusive)}

\item{jmin}{minimum j index of cropped area (inclusive)}

\item{jmax}{maximum j index of cropped area (inclusive)}

\item{kmin}{minimum k index of cropped area (inclusive)}

\item{kmax}{maximum k index of cropped area (inclusive)}
}
\value{
Cropped voxel space with updated i, j, k grid coordinates and
updated header (min and max corner).
}
\description{
Crop \code{\linkS4class{VoxelSpace}} object based on voxel i, j,
k, index. If cropping index are missing, the function will automatically crop
the voxel space by discarding outermost unsampled slices of voxels. A \emph{slice}
designates a layer with constant i (i-slice), j (j-slice) or k (k-slice).
\emph{unsampled} means that no pulse went through.

One may want to crop the voxel space on coordinates rather than grid index.
To do so the voxel space must be first converted to an \code{\link[sf:sf]{sf::sf}}
object and use the \code{\link[sf:st_crop]{sf::st_crop()}} function.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vxsp <- readVoxelSpace(system.file("extdata", "tls_sample.vox", package = "AMAPVox"))
vxsp@data[, c("x", "y"):=getPosition(vxsp)[, .(x, y)]]
library(sf)
vx.sf <- sf::st_as_sf(vxsp@data, coords=c("x", "y"))
vx.sf <- sf::st_crop(vx.sf, c(xmin = 4, ymin = 1, xmax = 5, ymax = 4))
sf::st_bbox(vx.sf)
vxsp@data <- sf::st_drop_geometry(vx.sf)
}\if{html}{\out{</div>}}
}
\examples{
\dontrun{
vxsp <- readVoxelSpace(system.file("extdata", "tls_sample.vox", package = "AMAPVox"))
plot(crop(vxsp, imin = 1, imax = 5))
# introduce unsampled areas in voxel space
vxsp@data[i < 3, nbSampling:= 0]
# automatic cropping
plot(crop(vxsp))
}

}
