% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochasticity_module.R
\name{Stochasticity module}
\alias{Stochasticity module}
\alias{stochParamsSetterUI}
\alias{stochParamsSetterServer}
\alias{set_stoch_params}
\title{stochParamsSetterUI}
\usage{
stochParamsSetterUI(
  id,
  show_var = FALSE,
  show_biol_sigma = TRUE,
  show_est_sigma = TRUE,
  show_est_bias = TRUE,
  init_biol_sigma = 0,
  init_est_sigma = 0,
  init_est_bias = 0
)

stochParamsSetterServer(id)

set_stoch_params(input)
}
\arguments{
\item{id}{The id (shiny magic)}

\item{show_var}{Show the variability options when app opens (default is FALSE).}

\item{show_biol_sigma}{Show the biological productivity variability option (default is TRUE).}

\item{show_est_sigma}{Show the estimation variability option (default is TRUE).}

\item{show_est_bias}{Show the estimation bias option (default is TRUE).}

\item{init_biol_sigma}{Default value for biological productivity variability (ignored if not shown).}

\item{init_est_sigma}{Default value for estimation variability (ignored if not shown).}

\item{init_est_bias}{Default value for estimation bias (ignored if not shown).}

\item{input}{A list of stochasticity parameters.}
}
\value{
A taglist

A list of stochasticity options.
}
\description{
stochParamsSetterUI() is the UI part for the stochasticity options.
Stochasticity is included in the projections in two areas: biological variability (e.g. recruitment)
and estimation error (to represent the difference between the 'true' status of the stock and the estimated status that is used by the HCR).
Estimation error includes bias and variability.
The arguments to this function allow only some of these elements to be shown.

stochParamSetterServer() does the server side stuff for the stochasticity options.

set_stoch_params() sets up default values for the stochasticity parameters.
Defined as a separate function so it can be used for testing outside of a reactive environment.
}
