% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{microorganisms}
\alias{microorganisms}
\title{Dataset with ~2500 microorganisms}
\format{A data.frame with 2453 observations and 12 variables:
\describe{
  \item{\code{bactid}}{ID of microorganism}
  \item{\code{bactsys}}{Bactsyscode of microorganism}
  \item{\code{family}}{Family name of microorganism}
  \item{\code{genus}}{Genus name of microorganism, like \code{"Echerichia"}}
  \item{\code{species}}{Species name of microorganism, like \code{"coli"}}
  \item{\code{subspecies}}{Subspecies name of bio-/serovar of microorganism, like \code{"EHEC"}}
  \item{\code{fullname}}{Full name, like \code{"Echerichia coli (EHEC)"}}
  \item{\code{type}}{Type of microorganism, like \code{"Bacteria"} and \code{"Fungus/yeast"}}
  \item{\code{gramstain}}{Gram of microorganism, like \code{"Negative rods"}}
  \item{\code{aerobic}}{Logical whether bacteria is aerobic}
  \item{\code{type_nl}}{Type of microorganism in Dutch, like \code{"Bacterie"} and \code{"Schimmel/gist"}}
  \item{\code{gramstain_nl}}{Gram of microorganism in Dutch, like \code{"Negatieve staven"}}
}}
\source{
MOLIS (LIS of Certe) - \url{https://www.certe.nl}
}
\usage{
microorganisms
}
\description{
A dataset containing 2453 microorganisms. MO codes of the UMCG can be looked up using \code{\link{microorganisms.umcg}}.
}
\seealso{
\code{\link{guess_bactid}} \code{\link{antibiotics}} \code{\link{microorganisms.umcg}}
}
\keyword{datasets}
