% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runs.ncat.R
\name{runs.ncat}
\alias{runs.ncat}
\title{Perform Runs test for three or more categories}
\usage{
runs.ncat(
  x,
  alternative = c("two.sided", "less", "greater"),
  cont.corr = TRUE,
  nsims.mc = 1e+05,
  seed = NULL,
  do.asymp = TRUE,
  do.mc = FALSE
)
}
\arguments{
\item{x}{Vector or factor}

\item{alternative}{Type of alternative hypothesis (defaults to \code{two.sided})}

\item{cont.corr}{Boolean indicating whether or not to use continuity correction (defaults to \code{TRUE})}

\item{nsims.mc}{Number of Monte Carlo simulations to be performed (defaults to \code{100000})}

\item{seed}{Random number seed to be used for Monte Carlo simulations (defaults to \code{NULL})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{TRUE})}

\item{do.mc}{Boolean indicating whether or not to perform Monte Carlo calculations (defaults to \code{FALSE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{runs.ncat()} performs the Runs test for three or more categories and is used in chapters 4 and 7 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 4.15 from "Applied Nonparametric Statistical Methods" (5th edition)
runs.ncat(ch4$births, alternative = "less")

# Exercise 7.16 from "Applied Nonparametric Statistical Methods" (5th edition)
runs.ncat(ch7$regions[order(ch7$affordability)], alternative = "less")

}
