% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kstest.ANSM.R
\name{kstest.ANSM}
\alias{kstest.ANSM}
\title{Perform Smirnov test and Kolgomorov test}
\usage{
kstest.ANSM(
  x,
  y,
  ...,
  alternative = c("two.sided", "less", "greater"),
  max.exact.cases = 1000,
  do.asymp = FALSE,
  do.exact = TRUE
)
}
\arguments{
\item{x}{Numeric vector}

\item{y}{Numeric vector or a character string naming a cumulative distribution function or an actual cumulative distribution function}

\item{...}{For the default method of \code{ks.test}, parameters of the distribution specified (as a character string) by y. Otherwise, further arguments to be passed to or from methods}

\item{alternative}{Type of alternative hypothesis (defaults to \code{two.sided})}

\item{max.exact.cases}{Maximum number of cases allowed for exact calculations (defaults to \code{1000})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{kstest.ANSM()} is a wrapper for ks.test() from the \code{stats} package - performs the Smirnov test and Kolgomorov test and is used in chapters 4, 6 and 9 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Exercise 4.3 from "Applied Nonparametric Statistical Methods" (5th edition)
kstest.ANSM(ch4$visiting.supporters, "pexp", rate = 2600)

# Exercise 9.2 from "Applied Nonparametric Statistical Methods" (5th edition)
kstest.ANSM(ch9$boys.toothtime, ch9$girls.toothtime)

}
