% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgn.test.R
\name{sgn.test}
\alias{sgn.test}
\title{Perform Sign test}
\usage{
sgn.test(
  x,
  H0 = NULL,
  alternative = c("two.sided", "less", "greater"),
  cont.corr = TRUE,
  CI.width = 0.95,
  max.exact.cases = 1e+06,
  do.asymp = FALSE,
  do.exact = TRUE,
  do.CI = TRUE
)
}
\arguments{
\item{x}{Numeric vector, or binary factor and H0 is NULL}

\item{H0}{Null hypothesis value (defaults to \code{NULL})}

\item{alternative}{Type of alternative hypothesis (defaults to \code{two.sided})}

\item{cont.corr}{Boolean indicating whether or not to use continuity correction (defaults to \code{TRUE})}

\item{CI.width}{Confidence interval width (defaults to \code{0.95})}

\item{max.exact.cases}{Maximum number of cases allowed for exact calculations (defaults to \code{1000000})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}

\item{do.CI}{Boolean indicating whether or not to perform confidence interval calculations (defaults to \code{TRUE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{sgn.test()} performs the Sign test and is used in chapters 3, 4, 5 and 6 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 3.1 from "Applied Nonparametric Statistical Methods" (5th edition)
sgn.test(ch3$sampleI, 110)

# Exercise 6.2 from "Applied Nonparametric Statistical Methods" (5th edition)
sgn.test(ch5$LVF - ch5$RVF, 0)

}
