% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bs.R
\name{bs}
\alias{bs}
\title{Create bootstrap confidence interval}
\usage{
bs(x, y = NULL, CI.width = 0.95, nsims.bs = 10000, seed = NULL)
}
\arguments{
\item{x}{Numeric vector}

\item{y}{Numeric vector or NULL (defaults to \code{NULL})}

\item{CI.width}{Confidence interval width (defaults to \code{0.95})}

\item{nsims.bs}{Number of bootstrap samples to be taken (defaults to \code{10000})}

\item{seed}{Random number seed to be used for Monte Carlo simulations (defaults to \code{NULL})}
}
\value{
A list object object with the results from applying the function
}
\description{
\code{bs()} creates a bootstrap confidence interval and is used in chapter 14 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 14.5 from "Applied Nonparametric Statistical Methods" (5th edition)
bs(ch14$example14.2, nsims.bs = 2000, CI.width = 0.95, seed = 1)
bs(ch14$example14.2, nsims.bs = 2000, CI.width = 0.99, seed = 1)

}
