% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ant.R
\name{ant}
\alias{ant}
\title{ANT diagnostic for permuted statistics}
\usage{
ant(x, progress = FALSE)
}
\arguments{
\item{x}{an ANT object from functions: stat.t, stat.c, stat.lm, stat.glm, stat.glmm pr a numeric vector or a data frame with only numeric values.}

\item{progress}{a Boolean indicating if functions output should be printed in addition to the return object.}
}
\value{
A list of two elements fot stat.cor, stat.t functions:
\itemize{
\item A data frame with the permuted p-values (left side and right side), the confidence interval (25, 50 or 95) and the mean of the posterior distribution of the statistics of interest according to the statistical test (coefficient of correlation, t of students, or estimate(s))
\item An histogram of the posterior distribution of the statistics of interest according to the statistical test.
}
#' A list of four elements fot stat.lm, stat.glm, stat.glmm functions:
\itemize{
\item A data frame with the orginal stats of the model, and permuted p-values (left side and right side), the confidence interval (25, 50 or 95) and the mean of the posterior distribution of the statistics of interest according to the statistical test (coefficient of correlation, t of students, or estimate(s))
\item Diagnostic plot of the original model
\item An histogram of the posterior distribution of the statistics of interest according to the statistical test.
\item a vector of the permutations that generates errors and for which new permutations were performed.
}
}
\description{
ANT method to make a diagnostic of all ANT permutation tests. This method adapts the diagnostic results according to the data input. The
output is adapted to the type of test run. However, some outputs are common to all tests.
}
\examples{
t=met.strength(sim.m,sim.df,1) # Computing network metric
t=perm.net.nl(t,labels='age',rf=NULL,nperm=10,progress=FALSE) # Node label permutations
r.c=stat.cor(t,'age','strength',progress=FALSE) # Permuted correlation test
r=ant(r.c)
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez.
}
