md_deprecation_docstring <- function() {
	paste(
		'***ALL v0.1.x functions are deprecated***, and the workflow has been ',
		'completely revamped - now depending on the scRepertoire v2 package - ',
		'which allows for the processing of multi-sampled single cell data. ',
		'Please read the vignettes with `browseVignettes("APackOfTheClones")`',
		'or visit https://qile0317.github.io/APackOfTheClones/',
		sep = ""
	)
}

deprecation_docstring <- function() {
	gsub("*", "", md_deprecation_docstring(), fixed = TRUE)
}

#' DEPRECATED: Integrate a single TCR library into Seurat object metadata
#'
#' @description
#' `r lifecycle::badge('deprecated')`
#'
#' `r md_deprecation_docstring()`
#'
#' Modifies a `Seurat` object's metadata by taking all the columns
#' of the `all_contig_annotations.csv`, and adding new elements to
#' `seurat_obj@meta.data`, corresponding to each cells' barcodes and handling
#' duplicates (since the sequencing of TRA and TRB genes creates multiple data
#' points for the same cell).
#'
#' @details
#' Columns from cells (barcodes) that had duplicates in another row are
#' concatenated into strings, separated by `__` in the metadata element.
#' Barcodes from the TCR library that had no matches to barcodes in the
#' `seurat_obj` will add `NA`s for all elements of the same index.
#'
#' @param seurat_obj Seurat object
#' @param tcr_file `data.frame` of the T cell library generated by Cell Ranger.
#' It is very important that the row with cell barcodes is strictly named
#' `"barcode"`, which is the default name of barcodes in 10X's
#' `all_contig_annotations.csv` file.
#' @param verbose if `TRUE`, will display a progress bar to the R console.
#'
#' @return Returns a new Seurat object with new elements in the metadata
#'
#' @export
#' @importFrom data.table .GRP
#' @importFrom data.table .SD
#'
#' @keywords internal
#'
#' @examples
#' library(Seurat)
#' library(APackOfTheClones)
#' data("mini_clonotype_data","mini_seurat_obj")
#'
#' # integrate the TCR data into new seurat object
#' integrated_seurat_object <- integrate_tcr(
#'     mini_seurat_obj, mini_clonotype_data, verbose = FALSE
#' )
#'
#' integrated_seurat_object
#'
#' @references
#' atakanekiz (2019) Tutorial:Integrating VDJ sequencing data with Seurat.
#' `https://www.biostars.org/p/384640/`
#'
integrate_tcr <- function(seurat_obj, tcr_file, verbose = TRUE) {
	time_called <- Sys.time()

	lifecycle::deprecate_warn(
		when = "1.0.0",
		what = I("integrate_tcr")
	)

	seurat_obj <- dev_integrate_tcr(seurat_obj, tcr_file, verbose)

	seurat_obj@commands[["integrate_tcr"]] <- make_apotc_command(time_called)
	seurat_obj
}

dev_integrate_tcr <- function(seurat_obj, tcr_file, verbose) {
	tcr <- data.table::as.data.table(tcr_file)

	# Prepare a progress bar to monitor progress (helpful for large aggregations)
	if (verbose) {
		message("integrating TCR library into seurat object")
		grpn <- data.table::uniqueN(tcr$barcode)
		pb <- utils::txtProgressBar(min = 0, max = grpn, style = 3)
	}

	# Generate a function that will concatenate unique data entries and collapse
	# duplicate rows. first factorize the data and then get factor levels as
	# unique data points. Then data points are pasted together separated with
	# "__" to access later on if needed

	data_concater <- function(x){
		x <- levels(factor(x)) # not sure if na.omit is needed on x
		paste(x, collapse = "__")
	}

	# This code applies data_concater function per  barcodes to create a
	# concatenated string with  the information we want to keep

	if (verbose) {
		tcr_collapsed <- tcr[, {utils::setTxtProgressBar(pb, .GRP);
			lapply(.SD, data_concater)},
			by = "barcode"
		]
	} else {
		tcr_collapsed <- tcr[, lapply(.SD, data_concater), by = "barcode"]
	}

	# assign rownames for integration and add metadata
	rownames(tcr_collapsed) <- tcr_collapsed$barcode

	# remove NA
	tcr_collapsed <- stats::na.omit(tcr_collapsed)

	seurat_obj <- Seurat::AddMetaData(
		seurat_obj,
		metadata = tcr_collapsed
	)

	if (verbose) {
		percent_integrated <- 100 - percent_na(seurat_obj)
		message(paste(
			"\nPercent of unique barcodes:",
			as.character(round(percent_integrated)),
			"%"
		))
	}

	return(seurat_obj)
}

#' @title
#' DEPRECATED: count the number of clonotype sizes per cell cluster in a seurat
#' object integrated with a TCR library
#'
#' @description
#' `r lifecycle::badge("deprecated")`
#'
#' `r md_deprecation_docstring()`
#'
#' @details
#' The function is no longer needed as the `scRepertoire` workflow takes care
#' of this step.
#'
#' @param integrated_seurat_obj Seurat object that has been integrated with a
#' T-cell receptor library with the deprecated function
#' \code{\link{integrate_tcr}}. More specifically, in the metadata, there must
#' at least be the elements `seurat_clusters` and `raw_clonotype_id`
#'
#' @return A list of `table` objects, where each element is tabled
#' clonotype frequencies for the seurat cluster corresponding to the same index
#' - 1. For example, the 5th element is a tabled frequency of counts that
#' corresponds to the 4th seurat cluster (as seurat clusters are 0-indexed).
#' If an element is `NULL`, it indicates that there were no corresponding T-cell
#' receptor barcode for the cells in the cluster.
#'
#' @export
#'
#' @examples
#' library(Seurat)
#' library(APackOfTheClones)
#' data("mini_clonotype_data","mini_seurat_obj")
#'
#' # produce an integrated seurat_object
#' integrated_seurat_object <- integrate_tcr(
#'     mini_seurat_obj, mini_clonotype_data, verbose = FALSE
#' )
#'
#' clonotype_counts <- count_clone_sizes(integrated_seurat_object)
#' clonotype_counts
#'
count_clone_sizes <- function(integrated_seurat_obj) {

	lifecycle::deprecate_warn(
		when = "1.0.0",
		what = I("`count_clone_sizes`"),
		with = I("countCloneSizes")
	)

	if (is.null(integrated_seurat_obj@meta.data[["seurat_clusters"]])) {
		stop("No seurat clusters detected on the seurat object")
	}
	if (is.null(integrated_seurat_obj@meta.data[["raw_clonotype_id"]])) {
		stop(paste(
			"Seurat object is not integrated with a T-cell receptor,",
			"library or has no metadata `raw_clonotype_id`"
		))
	}

	df <- data.frame(
		"clusters" = integrated_seurat_obj@meta.data[["seurat_clusters"]],
		"clonotype_ids" = integrated_seurat_obj@meta.data[["raw_clonotype_id"]]
	)

	freq_df <- stats::aggregate(
		clonotype_ids ~ clusters, data = df, function(x) table(x)
	)

	num_clusters <- length(levels(
		integrated_seurat_obj@meta.data[["seurat_clusters"]]
	))

	freq <- vector("list", num_clusters)
	for (i in seq_len(nrow(freq_df))) {
		freq[[freq_df[[1]][i]]] <- table(as.numeric(freq_df[[2]][[i]]))
	}
	
	freq
}

#' @title
#' DEFUNCT: Visualize T cell clonal expansion with a ball-packing plot.
#'
#' @description
#' `r lifecycle::badge("defunct")`
#'
#' `r md_deprecation_docstring()`
#'
#' @param ... arbitrary arguments
#'
#' @keywords internal
#'
#' @return error message
#' @export
#'
clonal_expansion_plot <- function(...) {
	lifecycle::deprecate_stop(
		when = "1.0.0",
		what = I(
			"visualizing clonal expansion with `clonal_expansion_plot`"
		),
		with = I("vizAPOTC")
	)
}
