% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{check_problems}
\alias{check_problems}
\title{Check problems in output of \code{clean_metadata()}}
\usage{
check_problems(
  df,
  check = c("site_id", "aru_id", "date", "date_time", "longitude", "latitude"),
  path = FALSE,
  date = FALSE
)
}
\arguments{
\item{df}{Data frame. Either meta data (\code{clean_metadata()}) or GPS
coordinates (\code{clean_gps()})}

\item{check}{Character. Character vector of columns to check for missing
values. Default is \code{site_id}, \code{aru_id}, \code{date}, \code{date_time}, \code{longitude}
and \code{latitude}.}

\item{path}{Logical. Whether to return just the file paths which have missing
attributes. Default \code{FALSE}}

\item{date}{Logical. Whether to summarize output by date (as well as
\code{site_id} and \code{aru_id}. Default \code{FALSE}.}
}
\value{
A data frame summarizing the metadata by site_id, aru_type, aru_id,
and (optionally) by date. Presents the number of files, directories, and days
worth of recordings, as well as the minimum and maximum recording times.
}
\description{
Cleaning metadata can take a series of tries. This function helps summarize
and explore missing metadata (problems).
}
\examples{

m <- clean_metadata(project_files = example_files, pattern_aru_id = "test")

check_problems(m)
check_problems(m, date = TRUE)
check_problems(m, path = TRUE)
}
