% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_eqn.R
\name{custom.eqn}
\alias{custom.eqn}
\title{Make your own custom satellite image product}
\usage{
custom.eqn(directory = getwd(), cus.formula = "none", crop = "n",
  ext2crop = "none")
}
\arguments{
\item{cus.formula}{Assign custom formula to be computed AS TEXT input (inside double quotes).
To assign bands, ONLY USE BELOW DEFINED WORDS to indicate different bands in the formula.

nir for NIR (Near Infra-red) Top Of Atmosphere (TOA) reflectance band.

red for Red TOA reflectance band.

green for Green TOA reflectance band.

blue for Blue TOA reflectance band.

swir1 for SWIR-1 (Short Wave Infra-red -1)

swir2 for SWIR-2 (Short Wave Infra-red -2)

aero for Aerosol/coastal band (Only on Landsat OLI images)}

\item{ext2crop, crop, directory}{Same as mentioned in \code{\link[ASIP]{arvi}}.}
}
\value{
File named ur raster_'date of satellite image acqisition'.tif in the input folder
}
\description{
If any product or index is not available in this package, you don't need to do it manually.
This function intakes a custom formula & produced new product according to the formula.
This function converts DN bands to corresponding TOA reflectance prior to the computation of user defined formula.
}
\note{
1. FILENAMES OF ANY BAND FILES (*.TIF files) SHOULDN'T CHANGED.

2. Windows users should be careful while assigning directory. Use "/" to seperate folders not "\\".

3. Earth-sun distance is calculated according to Epema (1992) if the value is not mentioned in the meta data (*MTL.txt) file.

4. Currently recommended ESUN values provided by \href{https://landsat.usgs.gov/esun}{USGS} is used.
}
\examples{
library (raster)
library (rgdal)
# Finding the path of the sample satellite image directory.
# User may define paths directly like "/home/ur_folder" or "C:/ur_folder"
path <- system.file ("TM_sample", package = "ASIP")
# Input equation should be as text (inside double quotes)
eqn <- "(2* (nir^2)+ (2.20 + green))/ (blue / (2 * pi))"
shapefil <- paste0 (path, "/test.shp")
custom.eqn (directory = path, cus.formula = eqn, crop = "y", ext2crop = shapefil)
}
\references{
\href{http://www.tandfonline.com/doi/ref/10.1080/01431169208904159}{Epema G F (1992) Atmospheric condition and its influence on reflectance
of bare soil surfaces in southern Tunisia. International Journal of Remote Sensing, 13(5), pp:853-868. doi:10.1080/01431169208904159.}
}
