% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndvi.R
\name{ndvi}
\alias{ndvi}
\title{Normalized Difference Vegetation Index}
\usage{
ndvi(directory = getwd(), crop = "n", ext2crop = "none")
}
\arguments{
\item{ext2crop, crop, directory}{Same as mentioned in \code{\link[ASIP]{arvi}}.}
}
\value{
File named ndvi_'date of satellite image acqisition'.tif in the input folder
}
\description{
Normalized Difference Vegetation Index (NDVI). It is the most widely used satellite image derived index emphasizing on vegetation mapping.
}
\note{
1. NDVI= (r_nir - r_red)/(r_nir + r_red)

where, "r_" denotes TOA reflectance band.

Other important notes are mentioned in \code{\link[ASIP]{custom.eqn}}.
}
\examples{
library (raster)
library (rgdal)
# Finding the path of the sample satellite image directory.
# User may define paths directly like "/home/ur_folder" or "C:/ur_folder"
path <- system.file ("TM_sample", package = "ASIP")
shapefil <- paste0 (path, "/test.shp")
ndvi (directory = path, crop = "y", ext2crop = shapefil)
}
\references{
\href{http://www.sciencedirect.com/science/article/pii/0034425787900381}{Huetet A R and Jackson R D (1987) Suitability of spectral indices for evaluating vegetation characteristics on arid rangelands, Remote sensing of environment, 23(2), pp:213-232. doi: 10.1016/0034-4257(87)90038-1.}
}
