% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorpusCoder.R
\name{CorpusCoder}
\alias{CorpusCoder}
\title{Codes a corpus for use with NDL with vector of wavefile names and a vector of TextGrid names provided}
\usage{
CorpusCoder(Waves, Annotations, AnnotationType = c("TextGrid", "ESPS"),
  TierName = NULL, Dismiss = NULL, Encoding, Fast = F, Cores = 1,
  IntensitySteps, Smooth)
}
\arguments{
\item{Waves}{Vector with names (and full path to if not in wd) of the wave files.}

\item{Annotations}{Vector with names (and full path to if not in wd) of the TextGrid files.}

\item{AnnotationType}{Type of annotation files. Suported formats are praat TextGrids (set to "TextGrid") and ESPS/Wavesurfer (set to "ESPS") files.}

\item{TierName}{Name of the tier in the TextGrid to be used.}

\item{Dismiss}{Regular expression for Outcomes that should be removed. Uses grep.
E.g. "<|>" would remove <noise>,<xxx>, etc. Default is NULL.}

\item{Encoding}{Encoding of the annotation file. It is assumed, that all annotation files have the same encoding.}

\item{Fast}{Switches between a fast and a robust TextGrid parser.
For Fast no "\\n" or "\\t" may be in the transcription. Default is FALSE.}

\item{Cores}{Number of cores that the function may use. Default is 1.}

\item{IntensitySteps}{Number of steps that the intensity gets compressed to. Default is 5}

\item{Smooth}{A parameter for using the kernel smooth function provied by the package zoo.}
}
\value{
A data.frame with $Cues and $Outcomes for use with ndl or ndl2.
}
\description{
Codes a corpus for use with NDL with vector of wavefile names and a vector of TextGrid names provided
}
\examples{
       \dontrun{
       # assuming the corpus contains wave files and praat textgrids
           
         setwd(~/Data/MyCorpus) # assuming everything is in one place
           
         #assuming you have one wav for each annotation
           
         Waves=list.files(pattern="*.wav",recursive=T)
         Annotations=list.files(pattern="*.TextGrids",recursive=T) # see above
           
         # Lets assume the annotation is in UTF-8 and you want everything from a tier called words
         # Lets assume tha you want to dismiss everything in <|>
         # Lets assume that have 4 cores available
         # Lets assume that you want the defaut settings for the parameters
           
         Data=CorpusCoderCorpusCoder(Waves, Annotations, AnnotationType = "TextGrid",
         TierName = "words", Dismiss = "<|>", Encoding, Fast = F, Cores = 4, 
         IntensitySteps = 5, Smooth = 800)
         
       }
}
\author{
Denis Arnold
}
