% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_point.r
\name{report_point}
\alias{report_point}
\title{Generates reports based on input points.}
\usage{
report_point(period, acti_data, tz = "UTC", ...)
}
\arguments{
\item{period}{a dataframe containing participants, start and end date/time interval}

\item{acti_data}{a dataframe of the form "acti_data".}

\item{tz}{is the time zone. Optional argument. tz = "UTC" by default.}

\item{...}{Optional parameters}
}
\value{
a dataframe
}
\description{
Generates reports based on input points.
}
\details{
Periods partially scored as 'bad' or 'EXCLUDED' are due to off-wrist or other reasons.
In that case the column ‘with_excluded_bad’ will show TRUE. See examples in the Vignettes.
}
\examples{
# Example 1
library(lubridate)
par_point <- data.frame(subject_ID = c(1,1),
                       time_point_datime = ymd_hms(c("2017-12-06 00:00:00 UTC",
                       "2017-12-07 00:00:00 UTC")))
report_point(period = par_point, acti_data = act)
}
