% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{generate_age_pop_table}
\alias{generate_age_pop_table}
\title{Generate Age Population Tables}
\usage{
generate_age_pop_table(
  predictor_data,
  scale_pred,
  shape_pred,
  age_range = c(0, 99),
  age_interval = 1,
  country_code,
  ignore_cache = FALSE,
  output_dir,
  n_cores = parallel::detectCores() - 2
)
}
\arguments{
\item{predictor_data}{Data frame containing population data with columns:
country, region, district, pop}

\item{scale_pred}{Matrix of scale parameters for gamma distribution
predictions}

\item{shape_pred}{Matrix of shape parameters for gamma distribution
predictions}

\item{age_range}{Numeric vector of length 2 specifying min and max ages,
default c(0,99)}

\item{age_interval}{Numeric interval size between age groups in years,
default 1}

\item{country_code}{Character ISO3 country code}

\item{ignore_cache}{Logical whether to ignore cached results, default FALSE}

\item{output_dir}{Character path to output directory}

\item{n_cores}{Integer number of cores for parallel processing, default
detectCores()-2}
}
\value{
List containing two data frames:
   - prop_df: Age-stratified population proportions with uncertainty intervals
   - pop_df: Age-stratified population counts with uncertainty intervals
}
\description{
Creates age-stratified population tables from predictor data and gamma
distribution parameters. Supports parallel processing and caching of results.
}
\examples{

\donttest{
predictor_data <- data.frame(
 country = rep("ABC", 1100),
  region = rep("Region1", 1100),
  district = rep("District1", 1100),
  pop = rep(1000, 1100)
)
scale_pred <- matrix(rep(1:10, 1100), nrow = 1100, ncol = 10)
shape_pred <- matrix(rep(1:10, 1100), nrow = 1100, ncol = 10)
output <- generate_age_pop_table(
  predictor_data, scale_pred, shape_pred, age_range = c(0, 99),
  age_interval = 10, country_code = "ABC", ignore_cache = TRUE,
  output_dir = tempdir(), n_cores = 1
)
}

}
