% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pas_getColumn.R
\name{pas_getColumn}
\alias{pas_getColumn}
\title{Return column of data from filtered PurpleAir Synoptic objects}
\usage{
pas_getColumn(
  pas = NULL,
  name = NULL,
  pattern = ".*",
  idPattern = ".*",
  isOutside = TRUE,
  isParent = TRUE
)
}
\arguments{
\item{pas}{PurpleAir Synoptic \emph{pas} object.}

\item{name}{Name of the column to return.}

\item{pattern}{Text pattern used to filter sensor labels.}

\item{idPattern}{Text pattern used to filter \code{deviceDeploymentID}.}

\item{isOutside}{Logical, is the sensor located outside?}

\item{isParent}{Logical, is the record associated with a the A channel?}
}
\value{
Vector of values.
}
\description{
The incoming \code{pas} object is first filtered based on the 
values of \code{states}, \code{pattern}, \code{isOutside} and \code{isParent}.
The values associated with the \code{name} column are then returned.

This function is useful for returning values associated with specific
\emph{devices}, which are represented by records with \code{isParent = TRUE}.
}
\examples{
library(AirSensor)

example_pas \%>\%
  pas_getColumn(name = "latitude") \%>\%
  head(10)
  
}
\seealso{
\code{\link{pas_getIDs}},  \code{\link{pas_getLabels}}
}
