% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat_outliers.R
\name{pat_outliers}
\alias{pat_outliers}
\title{Detect and replace time series outliers}
\usage{
pat_outliers(
  pat = NULL,
  windowSize = 15,
  thresholdMin = 8,
  replace = FALSE,
  showPlot = TRUE,
  data_shape = 18,
  data_size = 1,
  data_color = "black",
  data_alpha = 0.5,
  outlier_shape = 8,
  outlier_size = 1,
  outlier_color = "red",
  outlier_alpha = 1
)
}
\arguments{
\item{pat}{PurpleAir Timeseries \emph{pat} object.}

\item{windowSize}{Integer window size for outlier detection.}

\item{thresholdMin}{Threshold value for outlier detection.}

\item{replace}{Logical specifying whether replace outliers with the window
median value.}

\item{showPlot}{Logical specifying whether to generate outlier detection 
plots.}

\item{data_shape}{Symbol to use for data points.}

\item{data_size}{Size of data points.}

\item{data_color}{Color of data points.}

\item{data_alpha}{Opacity of data points.}

\item{outlier_shape}{Symbol to use for outlier points.}

\item{outlier_size}{Size of outlier points.}

\item{outlier_color}{Color of outlier points.}

\item{outlier_alpha}{Opacity of outlier points.}
}
\value{
A \emph{pat} object with outliers replaced by median values.
}
\description{
Outlier detection using a Median Average Deviation "Hampel" 
filter. This function applies a rolling Hampel filter to find those points
that are very far out in the tails of the distribution of values within the
window.

The \code{thresholdMin} level is similar to a sigma value for normally 
distributed data. The default threshold setting \code{thresholdMin = 8} 
identifies points that are extremely unlikely to be part of a normal 
distribution and therefore very likely to be an outlier. By choosing a 
relatively large value for `thresholdMin`` we make it less likely that we 
will generate false positives.

The default setting of the window size \code{windowSize = 15} means that 15 samples
from a single channel are used to determine the distribution of values for
which a median is calculated. Each PurpleAir channel makes a measurement
approximately every 120 seconds so the temporal window is 15 * 120 sec or
approximately 30 minutes. This seems like a reasonable period of time over
which to evaluate PM2.5 measurements.

Specifying \code{replace = TRUE} allows you to perform smoothing by 
replacing outliers with the window median value. Using this technique, you 
can create an highly smoothed, artificial dataset by setting 
\code{thresholdMin = 1} or lower (but always above zero).
}
\note{
Additional documentation on the algorithm is available in 
\code{seismicRoll::findOutliers()}.
}
\examples{
library(AirSensor) 

example_pat \%>\%
  pat_filterDate(20180801, 20180815) \%>\%
  pat_outliers(replace = TRUE, showPlot = TRUE)
}
