% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat_sample.R
\name{pat_sample}
\alias{pat_sample}
\title{Sample PurpleAir time series data}
\usage{
pat_sample(
  pat = NULL,
  sampleSize = NULL,
  sampleFraction = NULL,
  setSeed = NULL,
  keepOutliers = FALSE
)
}
\arguments{
\item{pat}{PurpleAir Timeseries \emph{pat} object.}

\item{sampleSize}{Non-negative integer giving the number of rows to choose.}

\item{sampleFraction}{Fraction of rows to choose.}

\item{setSeed}{Integer that sets random number generation. Can be used to 
reproduce sampling.}

\item{keepOutliers}{logical specifying a graphics focused sampling algorithm
(see Details).}
}
\value{
A subset of the given \emph{pat} object.
}
\description{
A sampling function that accepts PurpleAir timeseries dataframes
and reduces them by randomly selecting distinct rows of the users chosen 
size. 

If both \code{sampleSize} and \code{sampleFraction} are unspecified,
 \code{sampleSize = 5000} will be used.
}
\details{
When \code{keepOutliers = FALSE}, random sampling is used to provide
a statistically relevant subsample of the data.

When \code{keepOutliers = TRUE}, a customized sampling algorithm is used that
attempts to create subsets for use in plotting that create plots that are
visually identical to plots using all data. This is accomplished by
preserving outliers and only sampling data in regions where overplotting
is expected.

The process is as follows:
\enumerate{
\item{find outliers using \code{seismicRoll::findOutliers()}}
\item{create a subset consisting of only outliers}
\item{sample the remaining data}
\item{merge the outliers and sampled data}
}
}
\examples{
library(AirSensor)

example_pat \%>\%
  pat_extractData() \%>\%
  dim()

example_pat \%>\%
  pat_sample(sampleSize = 1000, setSeed = 1) \%>\%
  pat_extractData() \%>\%
  dim()

}
