% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat_scatterPlotMatrix.R
\name{pat_scatterPlotMatrix}
\alias{pat_scatterPlotMatrix}
\title{Draw a matrix of PurpleAir Timeseries data scatter plots}
\usage{
pat_scatterPlotMatrix(
  pat = NULL,
  parameters = c("datetime", "pm25_A", "pm25_B", "temperature", "humidity"),
  sampleSize = 5000,
  sampleFraction = NULL,
  size = 0.5,
  shape = 15,
  color = "black",
  alpha = 0.25
)
}
\arguments{
\item{pat}{PurpleAir Timeseries \emph{pat} object.}

\item{parameters}{Vector of parameters to include.}

\item{sampleSize}{Integer to determine sample size.}

\item{sampleFraction}{Fractional sample size.}

\item{size}{Size of points.}

\item{shape}{Symbol to use for points.}

\item{color}{Color of points.}

\item{alpha}{Opacity of points.}
}
\value{
Multi-panel ggplot comparing all parameters.
}
\description{
Creates a multi-panel scatterPlot comparing all variables in the
\emph{pat} object. If any variables have no valid data, they are omitted from
the plot.

The list of available parameters include:

\itemize{
\item{\code{datetime} -- measurement time}
\item{\code{pm25_A} -- A channel PM2.5 (ug/m3)}
\item{\code{pm25_B} -- B channel PM2.5 (ug/m3)}
\item{\code{temperature} -- temperature (F)}
\item{\code{humidity} -- humidity (\%)}
}
}
\examples{
\donttest{
library(AirSensor)

pat <- 
  example_pat \%>\% 
  pat_filterDate(20180811,20180818)
  
# NOTE:  Warnings are generated when the pat contains NA values
pat_scatterPlotMatrix(pat, sampleSize = 1000)
}
}
