% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-sensor.R
\name{sensor_isSensor}
\alias{sensor_isSensor}
\title{Test for correct structure in a \emph{sensor} object}
\usage{
sensor_isSensor(sensor = NULL)
}
\arguments{
\item{sensor}{\emph{sensor} object}
}
\value{
\code{TRUE} if \code{sensor} has the correct structure, \code{FALSE} otherwise.
}
\description{
The \code{sensor} is checked for the 'sensor' class name
and presence of core metadata columns:
\itemize{
  \item{ID -- Purple Air ID}
  \item{label -- location label}
  \item{sensorType -- PurpleAir sensor type}
  \item{longitude -- decimal degrees E}
  \item{latitude -- decimal degrees N}
  \item{timezone -- Olson timezone}
  \item{countryCode -- ISO 3166-1 alpha-2}
  \item{stateCode -- ISO 3166-2 alpha-2}
  \item{pwfsl_closestDistance -- distance in meters from an official monitor}
  \item{pwfsl_closestMonitorID -- identifer for the nearest official monitor}
}

The "pwfsl", official, monitors are obtained from the USFS AirFire site 
using the \pkg{PWFSLSmoke} R package.
}
\examples{
example_sensor <- pat_createAirSensor(example_pat)
sensor_isSensor(example_sensor)

}
\keyword{sensor}
