% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allelic_series_test.R
\name{ASKAT}
\alias{ASKAT}
\title{Allelic Series SKAT Test}
\usage{
ASKAT(
  anno,
  geno,
  pheno,
  apply_int = TRUE,
  covar = NULL,
  is_pheno_binary = FALSE,
  min_mac = 0,
  return_null_model = FALSE,
  weights = DEFAULT_WEIGHTS
)
}
\arguments{
\item{anno}{(snps x 1) annotation vector with values in c(0, 1, 2).}

\item{geno}{(n x snps) genotype matrix.}

\item{pheno}{(n x 1) phenotype vector.}

\item{apply_int}{Apply rank-based inverse normal transform to the phenotype?
Default: TRUE. Ignored if phenotype is binary.}

\item{covar}{(n x p) covariate matrix. Defaults to an (n x 1) intercept.}

\item{is_pheno_binary}{Is the phenotype binary? Default: FALSE.}

\item{min_mac}{Minimum minor allele count for inclusion. Default: 0.}

\item{return_null_model}{Return the null model in addition to the p-value?
Useful if running additional SKAT tests. Default: FALSE.}

\item{weights}{(3 x 1) annotation category weights.}
}
\value{
If \code{return_null_model}, a list containing the p-value and the
SKAT null model. Otherwise, a numeric p-value.
}
\description{
Sequence kernel association test (SKAT) with allelic series weights.
}
\examples{
# Generate data.
data <- DGP(n = 1e3, snps = 1e2)

# Run the Allelic Series SKAT Test.
# Note: the output is a scalar p-value.
results <- ASKAT(
  anno = data$anno,
  geno = data$geno,
  pheno = data$pheno,
  covar = data$covar
)
}
