% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/savePlot.plotSummaryAlphaPart.R
\name{savePlot}
\alias{savePlot}
\alias{savePlot.plotSummaryAlphaPart}
\title{savePlot.plotSummaryAlphaPart.R}
\usage{
savePlot(x, filename = paste("Rplot", type, sep = "."), type = c("pdf",
  "png", "jpeg", "tiff", "bmp"), device = dev.cur(), ...)

\method{savePlot}{plotSummaryAlphaPart}(x, filename = paste("Rplot",
  type, sep = "."), type = c("pdf", "png", "jpeg", "tiff", "bmp"),
  device = dev.cur(), pre.hook = NULL, traitsAsDir = FALSE, ...)
}
\arguments{
\item{x}{Object on which to chose savePLot method.}

\item{filename}{Character, filename to save to.}

\item{type}{Character, file/device type.}

\item{device}{Device, the device to save from. TODO}

\item{...}{Arguments passed to \code{type} specific methods, say
\code{width} and \code{height} for \code{type="pdf"} etc.}

\item{pre.hook}{Function, call some code before calling print method for plots (see examples).}

\item{traitsAsDir}{Logical, should plots be saved within trait folders; the construction is
\code{file.path(dirname(file), trait, basename(file))}.
folders are created if they do not exist.}
}
\value{
Beside the side effect of saving plots to disk, filenames are printed on
screen during the process and at the end invisibly returned.
}
\description{
Save plot objects on the disk for permanent storage. Function \code{\link[grDevices]{savePlot}} from the \pkg{grDevices} package
works for current page on graphical device. This is an attempt to make this
function generic so that one can define \code{savePlot} methods for particular
needs.
}
\section{Methods (by class)}{
\itemize{
\item \code{plotSummaryAlphaPart}: Save plot objects of class \code{plotSummaryAlphaPart} on the disk for
permanent storage.
}}

\examples{
## Load an example data
data("AlphaPart.ped")

## --- Partition additive genetic values by loc ---
(res <- AlphaPart(x=AlphaPart.ped, colPath="loc", colAGV=c("agv1", "agv2")))

## Summarize whole population
(ret <- summary(res))

## Summarize population by generation (=trend)
(ret <- summary(res, by="gen"))

## Summarize population by generation (=trend) and location 1
(ret <- summary(res, by="loc.gen"))

## Summarize population by generation (=trend) but only for location 1
(ret <- summary(res, by="gen", subset=res[[1]]$loc == 1))

## --- Partition additive genetic values by loc and sex ---

AlphaPart.ped$loc.sex <- with(AlphaPart.ped, paste(loc, sex, sep="-"))
(res <- AlphaPart(x=AlphaPart.ped, colPath="loc.sex", colAGV=c("agv1", "agv2")))

## Summarize population by generation (=trend)
(ret <- summary(res, by="gen"))

## Summarize population by generation (=trend) and location 1
(ret <- summary(res, by="loc.gen"))

## Summarize population by generation (=trend) but only for location 1
(ret <- summary(res, by="gen", subset=res[[1]]$loc == 1))
}
\seealso{
\code{\link[grDevices]{savePlot}} help page on the default \code{savePlot}
method in the \pkg{grDevices} package; \code{\link[AlphaPart]{savePlot.plotSummaryAlphaPart}}
help page on the method for the objects of \code{plotSummaryAlphaPart} class; and
\code{\link[AlphaPart]{plot.summaryAlphaPart}} for ploting results of summaryAlphaPart object.
}
