% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SimParam.R
\name{SimParam_addTraitAG}
\alias{SimParam_addTraitAG}
\title{Add additive GxE traits}
\arguments{
\item{nQtlPerChr}{number of QTLs per chromosome. Can be a single value or nChr values.}

\item{mean}{a vector of desired mean genetic values for one or more traits}

\item{var}{a vector of desired genetic variances for one or more traits}

\item{varGxE}{a vector of total genotype-by-environment variances for the traits}

\item{varEnv}{a vector of environmental variances for one or more traits}

\item{corA}{a matrix of correlations between additive effects}

\item{corGxE}{a matrix of correlations between GxE effects}

\item{gamma}{should a gamma distribution be used instead of normal}

\item{shape}{the shape parameter for the gamma distribution}

\item{force}{should the check for a running simulation be 
ignored. Only set to TRUE if you know what you are doing.}
}
\description{
Randomly assigns eligble QTLs for one ore more additive GxE traits. 
If simulating more than one trait, all traits will be pleiotrophic 
with correlated effects.
}
\section{Usage}{
 SP$addTraitAG(nQtlPerChr, mean = 0, var = 1, varGxE = 1e-6, 
varEnv = 0, corA = NULL, corGxE = NULL, gamma = FALSE, shape = 1)
}

\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitAG(10, varGxE=2)

}
