% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pullGeno.R
\name{getQtlMap}
\alias{getQtlMap}
\title{Get QTL genetic map}
\usage{
getQtlMap(trait = 1, gender = "A", simParam = NULL)
}
\arguments{
\item{trait}{an integer for the}

\item{gender}{determines which gender specific map 
is returned. Options are "A" for average map, "F" 
for female map, and "M" for male map. All options are 
equivalent if not using gender specific maps.}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
Returns a data.frame for the SNP map.
}
\description{
Retrieves the genetic map for the 
QTL of a given trait.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(5)

#Pull SNP map
getQtlMap(trait=1, simParam=SP)

}
