% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{smithHazel}
\alias{smithHazel}
\title{Calculate Smith-Hazel weights}
\usage{
smithHazel(econWt, varG, varP)
}
\arguments{
\item{econWt}{vector of economic weights}

\item{varG}{the genetic variance-covariance matrix}

\item{varP}{the phenotypic variance-covariance matrix}
}
\value{
a vector of weight for calculating index values
}
\description{
Calculates weights for Smith-Hazel index given economice weights 
and phenotypic and genotypic variance-covariance matrices.
}
\examples{
G = 1.5*diag(2)-0.5
E = diag(2)
P = G+E
wt = c(1,1)
smithHazel(wt, G, P)

}
