% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selection.R
\name{selectWithinFam}
\alias{selectWithinFam}
\title{Select individuals within families}
\usage{
selectWithinFam(
  pop,
  nInd,
  trait = 1,
  use = "pheno",
  sex = "B",
  famType = "B",
  selectTop = TRUE,
  returnPop = TRUE,
  candidates = NULL,
  simParam = NULL,
  ...
)
}
\arguments{
\item{pop}{and object of \code{\link{Pop-class}} or 
\code{\link{HybridPop-class}}}

\item{nInd}{the number of individuals to select within a family}

\item{trait}{the trait for selection. Either a number indicating 
a single trait or a function returning a vector of length nInd.}

\item{use}{select on genetic values "gv", estimated
breeding values "ebv", breeding values "bv", phenotypes "pheno", 
or randomly "rand"}

\item{sex}{which sex to select. Use "B" for both, "F" for 
females and "M" for males. If the simulation is not using sexes, 
the argument is ignored.}

\item{famType}{which type of family to select. Use "B" for 
full-sib families, "F" for half-sib families on female side and "M" 
for half-sib families on the male side.}

\item{selectTop}{selects highest values if true. 
Selects lowest values if false.}

\item{returnPop}{should results be returned as a 
\code{\link{Pop-class}}. If FALSE, only the index of selected 
individuals is returned.}

\item{candidates}{an optional vector of eligible selection candidates.}

\item{simParam}{an object of \code{\link{SimParam}}}

\item{...}{additional arguments if using a function for 
trait}
}
\value{
Returns an object of \code{\link{Pop-class}} or 
\code{\link{HybridPop-class}}
}
\description{
Selects a subset of nInd individuals from each  
full-sib family within a population. Will return all individuals 
from a full-sib family if it has less than or equal to nInd individuals.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)
SP$setVarE(h2=0.5)

#Create population
pop = newPop(founderPop, simParam=SP)

#Create 3 biparental families with 10 progeny
pop2 = randCross(pop, nCrosses=3, nProgeny=10, simParam=SP)

#Select best individual per family
pop3 = selectWithinFam(pop2, 1, simParam=SP)

}
