% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pullGeno.R
\name{pullSegSiteHaplo}
\alias{pullSegSiteHaplo}
\title{Pull seg site haplotypes}
\usage{
pullSegSiteHaplo(
  pop,
  haplo = "all",
  chr = NULL,
  asRaw = FALSE,
  simParam = NULL
)
}
\arguments{
\item{pop}{an object of \code{\link{RawPop-class}} or
\code{\link{MapPop-class}}}

\item{haplo}{either "all" for all haplotypes or an integer
for a single set of haplotypes. Use a value of 1 for female
haplotypes and a value of 2 for male haplotypes in diploids.}

\item{chr}{a vector of chromosomes to retrieve. If NULL,
all chromosome are retrieved.}

\item{asRaw}{return in raw (byte) format}

\item{simParam}{an object of \code{\link{SimParam}}, not 
used if pop is \code{\link{MapPop-class}}}
}
\value{
Returns a matrix of haplotypes
}
\description{
Retrieves haplotype data for all segregating sites
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=15)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)
SP$addSnpChip(5)

#Create population
pop = newPop(founderPop, simParam=SP)
pullSegSiteHaplo(pop, simParam=SP)

}
