% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workbench_icon.r
\docType{class}
\name{AmigaIcon}
\alias{AmigaIcon}
\title{The S3 AmigaIcon class}
\description{
A comprehensive representation of an Amiga Workbench icon file.
}
\details{
Files, directories and other similar objects were depicted as icons on the
Amiga Workbench (the Amiga's equivalent of what is now mostly known as the compmuter's
desktop). Icons were actually separate files with the exact same name as the
file or directory it represents, except for an additional `.info' extension.

In addition of being a graphical representation of files or directories, icon
files also contained additional information about the file. It could for instance
indicate which tool would be required to open the file.

The classic Amiga Workbench icon file has a rather complex structure as it is
basically a dump of how it is stored in memory. As a result it contains many
memory pointers that are really not necassary to store in a file.

The S3 AmigaIcon class is used to represent these complex files as a named
\code{list}. The elements in that \code{list} have mostly identical
names as listed in the document at the top referenced below. The names are usually
self-explenatory, but the referred documents can also be
consulted to obtain more detailed information with respect to each of
these elements. As pointed out ealier, not all elements will have a meaningful
use.

It is possible to change the values of the list, but not all values may be valid.
Note that they will not be fully checked for validity. Invalid values may result in errors
when writing to a binary file using \code{\link{write.AmigaIcon}}, or may simply not
work properly on an Amiga or in an emulator.

The original `.info' file could be extended with NewIcon or with an OS3.5
\code{\link{IFFChunk}} data, that allowed for icons with larger colour depths.
These extensions are currently not implemented.

Use \code{\link{simpleAmigaIcon}} for creating a simple \code{AmigaIcon} object which can
be modified. Use \code{\link{read.AmigaIcon}} to read, and \code{\link{write.AmigaIcon}}
to write workbench icon files (*.info). With \code{\link{rawToAmigaIcon}} and
\code{\link[AmigaFFH]{as.raw}} \code{AmigaIcon} can be coerced back and forth from
and to its raw (binary) form.
}
\references{
\url{http://www.evillabs.net/wiki/index.php/Amiga_Icon_Formats}
\url{http://fileformats.archiveteam.org/wiki/Amiga_Workbench_icon}
\url{http://krashan.ppa.pl/articles/amigaicons/}
\url{http://amigadev.elowar.com/read/ADCD_2.1/Libraries_Manual_guide/node0241.html}
\url{http://amigadev.elowar.com/read/ADCD_2.1/Includes_and_Autodocs_3._guide/node05D6.html}
}
\seealso{
Other AmigaIcon.operations: \code{\link{rawToAmigaIcon}},
  \code{\link{read.AmigaIcon}},
  \code{\link{simpleAmigaIcon}},
  \code{\link{write.AmigaIcon}}
}
\author{
Pepijn de Vries
}
